/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointFileGroupingRule;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.intellij.xdebugger.ui.DebuggerColors;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;

public class XDebuggerUtilImpl
extends XDebuggerUtil {
    private XLineBreakpointType<?>[] myLineBreakpointTypes;
    private Map<Class<? extends XBreakpointType>, XBreakpointType<?, ?>> myBreakpointTypeByClass;

    public XLineBreakpointType<?>[] getLineBreakpointTypes() {
        if (this.myLineBreakpointTypes == null) {
            XBreakpointType<?, ?>[] types = XBreakpointUtil.getBreakpointTypes();
            ArrayList<XLineBreakpointType> lineBreakpointTypes = new ArrayList<XLineBreakpointType>();
            for (XBreakpointType<?, ?> type : types) {
                if (!(type instanceof XLineBreakpointType)) continue;
                lineBreakpointTypes.add((XLineBreakpointType)type);
            }
            this.myLineBreakpointTypes = lineBreakpointTypes.toArray(new XLineBreakpointType[lineBreakpointTypes.size()]);
        }
        return this.myLineBreakpointTypes;
    }

    public void toggleLineBreakpoint(@NotNull Project project2, @NotNull VirtualFile file2, int line, boolean temporary) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        XLineBreakpointType<?> typeWinner = null;
        for (XLineBreakpointType<?> type : this.getLineBreakpointTypes()) {
            if (!type.canPutAt(file2, line, project2) || typeWinner != null && type.getPriority() <= typeWinner.getPriority()) continue;
            typeWinner = type;
        }
        if (typeWinner != null) {
            this.toggleLineBreakpoint(project2, typeWinner, file2, line, temporary);
        }
    }

    public boolean canPutBreakpointAt(@NotNull Project project2, @NotNull VirtualFile file2, int line) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "canPutBreakpointAt"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "canPutBreakpointAt"));
        }
        for (XLineBreakpointType<?> type : this.getLineBreakpointTypes()) {
            if (!type.canPutAt(file2, line, project2)) continue;
            return true;
        }
        return false;
    }

    public <P extends XBreakpointProperties> void toggleLineBreakpoint(@NotNull Project project2, @NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file2, int line, boolean temporary) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleLineBreakpoint"));
        }
        XSourcePositionImpl position = XSourcePositionImpl.create(file2, line);
        if (position != null) {
            XDebuggerUtilImpl.toggleAndReturnLineBreakpoint(project2, type, position, temporary, null);
        }
    }

    @NotNull
    public static <P extends XBreakpointProperties> Promise<XLineBreakpoint> toggleAndReturnLineBreakpoint(final @NotNull Project project2, final @NotNull XLineBreakpointType<P> type, final @NotNull XSourcePosition position, final boolean temporary, final @Nullable Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleAndReturnLineBreakpoint"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleAndReturnLineBreakpoint"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleAndReturnLineBreakpoint"));
        }
        Promise promise2 = (Promise)new WriteAction<Promise<XLineBreakpoint>>(){

            protected void run(@NotNull Result<Promise<XLineBreakpoint>> result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$1", "run"));
                }
                final VirtualFile file2 = position.getFile();
                final int line = position.getLine();
                final XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
                XLineBreakpoint breakpoint = breakpointManager.findBreakpointAtLine(type, file2, line);
                if (breakpoint != null) {
                    if (Registry.is((String)"debugger.click.disable.breakpoints")) {
                        breakpoint.setEnabled(!breakpoint.isEnabled());
                    } else {
                        breakpointManager.removeBreakpoint((XBreakpoint)breakpoint);
                    }
                } else {
                    List variants = type.computeVariants(project2, position);
                    if (!variants.isEmpty() && editor != null) {
                        RelativePoint relativePoint = DebuggerUIUtil.getPositionForPopup(editor, line);
                        if (variants.size() > 1 && relativePoint != null) {
                            final AsyncPromise res = new AsyncPromise();
                            int caretOffset = editor.getCaretModel().getOffset();
                            XLineBreakpointType.XLineBreakpointVariant defaultVariant = null;
                            for (XLineBreakpointType.XLineBreakpointVariant variant : variants) {
                                TextRange range = variant.getHighlightRange();
                                if (range == null || !range.contains(caretOffset) || defaultVariant != null && defaultVariant.getHighlightRange().getLength() <= range.getLength()) continue;
                                defaultVariant = variant;
                            }
                            final int defaultIndex = defaultVariant != null ? variants.indexOf(defaultVariant) : 0;
                            class MySelectionListener
                            implements ListSelectionListener {
                                RangeHighlighter myHighlighter = null;

                                MySelectionListener() {
                                }

                                @Override
                                public void valueChanged(ListSelectionEvent e) {
                                    if (!e.getValueIsAdjusting()) {
                                        this.clearHighlighter();
                                        Object value = ((JList)e.getSource()).getSelectedValue();
                                        if (value instanceof XLineBreakpointType.XLineBreakpointVariant) {
                                            TextRange range = ((XLineBreakpointType.XLineBreakpointVariant)value).getHighlightRange();
                                            TextRange lineRange = DocumentUtil.getLineTextRange(editor.getDocument(), line);
                                            if ((range = range != null ? range.intersection(lineRange) : lineRange) != null && !range.isEmpty()) {
                                                EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                                                TextAttributes attributes = scheme.getAttributes(DebuggerColors.BREAKPOINT_ATTRIBUTES);
                                                this.myHighlighter = editor.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 3001, attributes, HighlighterTargetArea.EXACT_RANGE);
                                            }
                                        }
                                    }
                                }

                                private void clearHighlighter() {
                                    if (this.myHighlighter != null) {
                                        this.myHighlighter.dispose();
                                    }
                                }
                            }
                            final MySelectionListener selectionListener = new MySelectionListener();
                            ListPopupImpl popup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<XLineBreakpointType.XLineBreakpointVariant>("Create breakpoint for", variants){
                                {
                                    super(arg0, arg1);
                                }

                                @NotNull
                                public String getTextFor(XLineBreakpointType.XLineBreakpointVariant value) {
                                    String string = value.getText();
                                    if (string == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$1$1", "getTextFor"));
                                    }
                                    return string;
                                }

                                public Icon getIconFor(XLineBreakpointType.XLineBreakpointVariant value) {
                                    return value.getIcon();
                                }

                                public void canceled() {
                                    selectionListener.clearHighlighter();
                                }

                                public PopupStep onChosen(XLineBreakpointType.XLineBreakpointVariant selectedValue, boolean finalChoice) {
                                    selectionListener.clearHighlighter();
                                    ApplicationManager.getApplication().runWriteAction(() -> {
                                        if (type == null) {
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$1$1", "lambda$onChosen$0"));
                                        }
                                        XBreakpointProperties properties = selectedValue.createProperties();
                                        res.setResult((Object)breakpointManager.addLineBreakpoint(type, file2.getUrl(), line, properties, temporary));
                                    });
                                    return FINAL_CHOICE;
                                }

                                public int getDefaultOptionIndex() {
                                    return defaultIndex;
                                }
                            });
                            DebuggerUIUtil.registerExtraHandleShortcuts(popup, "ToggleLineBreakpoint");
                            popup.setAdText(DebuggerUIUtil.getSelectionShortcutsAdText("ToggleLineBreakpoint"));
                            popup.addListSelectionListener(selectionListener);
                            popup.show(relativePoint);
                            result2.setResult((Object)res);
                            return;
                        }
                        XBreakpointProperties properties = ((XLineBreakpointType.XLineBreakpointVariant)variants.get(0)).createProperties();
                        result2.setResult((Object)Promise.resolve((Object)breakpointManager.addLineBreakpoint(type, file2.getUrl(), line, properties, temporary)));
                        return;
                    }
                    XBreakpointProperties properties = type.createBreakpointProperties(file2, line);
                    result2.setResult((Object)Promise.resolve((Object)breakpointManager.addLineBreakpoint(type, file2.getUrl(), line, properties, temporary)));
                    return;
                }
                result2.setResult(PromiseKt.rejectedPromise());
            }
        }.execute().getResultObject();
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "toggleAndReturnLineBreakpoint"));
        }
        return promise2;
    }

    public void removeBreakpoint(final Project project2, final XBreakpoint<?> breakpoint) {
        new WriteAction(){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$2", "run"));
                }
                XDebuggerManager.getInstance((Project)project2).getBreakpointManager().removeBreakpoint(breakpoint);
            }
        }.execute();
    }

    public <T extends XBreakpointType> T findBreakpointType(@NotNull Class<T> typeClass) {
        if (typeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeClass", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "findBreakpointType"));
        }
        if (this.myBreakpointTypeByClass == null) {
            this.myBreakpointTypeByClass = new THashMap();
            for (XBreakpointType<?, ?> breakpointType : XBreakpointUtil.getBreakpointTypes()) {
                this.myBreakpointTypeByClass.put(breakpointType.getClass(), breakpointType);
            }
        }
        XBreakpointType<?, ?> type = this.myBreakpointTypeByClass.get(typeClass);
        return (T)type;
    }

    public <T extends XDebuggerSettings<?>> T getDebuggerSettings(Class<T> aClass) {
        return XDebuggerSettingManagerImpl.getInstanceImpl().getSettings(aClass);
    }

    public XValueContainer getValueContainer(DataContext dataContext) {
        return XDebuggerTreeActionBase.getSelectedValue(dataContext);
    }

    @Nullable
    public XSourcePosition createPosition(VirtualFile file2, int line) {
        return XSourcePositionImpl.create(file2, line);
    }

    @Nullable
    public XSourcePosition createPosition(VirtualFile file2, int line, int column) {
        return XSourcePositionImpl.create(file2, line, column);
    }

    @Nullable
    public XSourcePosition createPositionByOffset(VirtualFile file2, int offset) {
        return XSourcePositionImpl.createByOffset(file2, offset);
    }

    @Nullable
    public XSourcePosition createPositionByElement(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        final VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 == null) {
            return null;
        }
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        return new XSourcePosition(){
            private volatile XSourcePosition myDelegate;

            private XSourcePosition getDelegate() {
                if (this.myDelegate == null) {
                    this.myDelegate = (XSourcePosition)ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement elem = pointer.getElement();
                        return XSourcePositionImpl.createByOffset(pointer.getVirtualFile(), elem != null ? elem.getTextOffset() : -1);
                    });
                }
                return this.myDelegate;
            }

            public int getLine() {
                return this.getDelegate().getLine();
            }

            public int getOffset() {
                return this.getDelegate().getOffset();
            }

            @NotNull
            public VirtualFile getFile() {
                VirtualFile virtualFile = file2;
                if (virtualFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$3", "getFile"));
                }
                return virtualFile;
            }

            @NotNull
            public Navigatable createNavigatable(@NotNull Project project2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$3", "createNavigatable"));
                }
                if (this.myDelegate != null) {
                    Navigatable navigatable = this.myDelegate.createNavigatable(project2);
                    if (navigatable == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$3", "createNavigatable"));
                    }
                    return navigatable;
                }
                PsiElement elem = pointer.getElement();
                if (elem instanceof Navigatable) {
                    Navigatable navigatable = (Navigatable)elem;
                    if (navigatable == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$3", "createNavigatable"));
                    }
                    return navigatable;
                }
                Navigatable navigatable = NonNavigatable.INSTANCE;
                if (navigatable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl$3", "createNavigatable"));
                }
                return navigatable;
            }
        };
    }

    public <B extends XLineBreakpoint<?>> XBreakpointGroupingRule<B, ?> getGroupingByFileRule() {
        return new XBreakpointFileGroupingRule();
    }

    @Nullable
    public static XSourcePosition getCaretPosition(@NotNull Project project2, DataContext context) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "getCaretPosition"));
        }
        Editor editor = XDebuggerUtilImpl.getEditor(project2, context);
        if (editor == null) {
            return null;
        }
        Document document2 = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document2);
        return XSourcePositionImpl.createByOffset(file2, offset);
    }

    @NotNull
    public static Collection<XSourcePosition> getAllCaretsPositions(@NotNull Project project2, DataContext context) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "getAllCaretsPositions"));
        }
        Editor editor = XDebuggerUtilImpl.getEditor(project2, context);
        if (editor == null) {
            List<XSourcePosition> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "getAllCaretsPositions"));
            }
            return list;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        SmartList res = new SmartList();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            XSourcePositionImpl position = XSourcePositionImpl.createByOffset(file2, caret.getOffset());
            if (position == null) continue;
            res.add(position);
        }
        SmartList smartList = res;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "getAllCaretsPositions"));
        }
        return smartList;
    }

    @Nullable
    private static Editor getEditor(@NotNull Project project2, DataContext context) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "getEditor"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor == null) {
            return FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        }
        return editor;
    }

    public <B extends XBreakpoint<?>> Comparator<B> getDefaultBreakpointComparator(XBreakpointType<B, ?> type) {
        return (o1, o2) -> type.getDisplayText(o1).compareTo(type.getDisplayText(o2));
    }

    public <P extends XBreakpointProperties> Comparator<XLineBreakpoint<P>> getDefaultLineBreakpointComparator() {
        return (o1, o2) -> {
            int fileCompare = o1.getFileUrl().compareTo(o2.getFileUrl());
            if (fileCompare != 0) {
                return fileCompare;
            }
            return o1.getLine() - o2.getLine();
        };
    }

    @Nullable
    public static XDebuggerEvaluator getEvaluator(XSuspendContext suspendContext) {
        XStackFrame stackFrame;
        XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
        if (executionStack != null && (stackFrame = executionStack.getTopFrame()) != null) {
            return stackFrame.getEvaluator();
        }
        return null;
    }

    public void iterateLine(@NotNull Project project2, @NotNull Document document2, int line, @NotNull Processor<PsiElement> processor2) {
        int lineEnd;
        int lineStart;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "iterateLine"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "iterateLine"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "iterateLine"));
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
        if (file2 == null) {
            return;
        }
        try {
            lineStart = document2.getLineStartOffset(line);
            lineEnd = document2.getLineEndOffset(line);
        }
        catch (IndexOutOfBoundsException ignored) {
            return;
        }
        int offset = lineStart;
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        while (offset < lineEnd) {
            PsiElement element = file2.findElementAt(offset);
            if (element != null) {
                if (!processor2.process((Object)element)) {
                    return;
                }
                offset = element.getTextRange().getEndOffset();
                continue;
            }
            ++offset;
        }
    }

    public <B extends XLineBreakpoint<?>> List<XBreakpointGroupingRule<B, ?>> getGroupingByFileRuleAsList() {
        return Collections.singletonList(this.getGroupingByFileRule());
    }

    @Nullable
    public PsiElement findContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project2, boolean checkXml) {
        PsiLanguageInjectionHost parent;
        PsiElement element;
        PsiFile file2;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "findContextElement"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "findContextElement"));
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile);
        PsiFile psiFile = file2 = document2 == null ? null : PsiManager.getInstance((Project)project2).findFile(virtualFile);
        if (file2 == null) {
            return null;
        }
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset > document2.getTextLength()) {
            offset = document2.getTextLength();
        }
        int startOffset = offset;
        int lineEndOffset = document2.getLineEndOffset(document2.getLineNumber(offset));
        PsiElement result2 = null;
        do {
            if ((element = file2.findElementAt(offset)) instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            result2 = element;
            break;
        } while ((offset = element.getTextRange().getEndOffset() + 1) < lineEndOffset);
        if (result2 == null) {
            result2 = file2.findElementAt(startOffset);
        }
        if (checkXml && result2 != null && StdFileTypes.XML.getLanguage().equals(result2.getLanguage()) && (parent = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)result2, PsiLanguageInjectionHost.class)) != null) {
            result2 = InjectedLanguageUtil.findElementInInjected(parent, offset);
        }
        return result2;
    }

    public void disableValueLookup(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "disableValueLookup"));
        }
        ValueLookupManager.DISABLE_VALUE_LOOKUP.set((UserDataHolder)editor, (Object)Boolean.TRUE);
    }

    @Nullable
    public static Editor createEditor(@NotNull OpenFileDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "createEditor"));
        }
        return descriptor.canNavigate() ? FileEditorManager.getInstance((Project)descriptor.getProject()).openTextEditor(descriptor, false) : null;
    }

    public static void rebuildAllSessionsViews(@Nullable Project project2) {
        if (project2 == null) {
            return;
        }
        for (XDebugSession session2 : XDebuggerManager.getInstance((Project)project2).getDebugSessions()) {
            if (!session2.isSuspended()) continue;
            session2.rebuildViews();
        }
    }

    @NotNull
    public XExpression createExpression(@NotNull String text, Language language, String custom, EvaluationMode mode) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "createExpression"));
        }
        XExpressionImpl xExpressionImpl = new XExpressionImpl(text, language, custom, mode);
        if (xExpressionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XDebuggerUtilImpl", "createExpression"));
        }
        return xExpressionImpl;
    }

    public static boolean isEmptyExpression(@Nullable XExpression expression) {
        return expression == null || StringUtil.isEmptyOrSpaces((String)expression.getExpression());
    }
}

