/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.impl.frame.XDebugView;
import org.jetbrains.annotations.NotNull;

public class XDebugViewSessionListener
implements XDebugSessionListener {
    private final XDebugView myDebugView;

    public XDebugViewSessionListener(@NotNull XDebugView debugView) {
        if (debugView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugView", "com/intellij/xdebugger/impl/frame/XDebugViewSessionListener", "<init>"));
        }
        this.myDebugView = debugView;
    }

    private void onSessionEvent(@NotNull XDebugView.SessionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XDebugViewSessionListener", "onSessionEvent"));
        }
        AppUIUtil.invokeOnEdt(() -> {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XDebugViewSessionListener", "lambda$onSessionEvent$0"));
            }
            this.myDebugView.processSessionEvent(event);
        });
    }

    public void sessionPaused() {
        this.onSessionEvent(XDebugView.SessionEvent.PAUSED);
    }

    public void sessionResumed() {
        this.onSessionEvent(XDebugView.SessionEvent.RESUMED);
    }

    public void sessionStopped() {
        this.onSessionEvent(XDebugView.SessionEvent.STOPPED);
    }

    public void stackFrameChanged() {
        this.onSessionEvent(XDebugView.SessionEvent.FRAME_CHANGED);
    }

    public void beforeSessionResume() {
        this.onSessionEvent(XDebugView.SessionEvent.BEFORE_RESUME);
    }
}

