/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.validate;

import com.intellij.javaee.UriUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.actions.validate.ErrorReporter;
import com.intellij.xml.util.XmlResourceResolver;
import java.io.StringReader;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidateXmlActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.actions.validate.ValidateXmlAction");
    @NonNls
    private static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String GRAMMAR_FEATURE_ID = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final String ENTITY_MANAGER_PROPERTY_ID = "http://apache.org/xml/properties/internal/entity-manager";
    private static final Key<XMLGrammarPool> GRAMMAR_POOL_KEY = Key.create((String)"GrammarPoolKey");
    private static final Key<Long> GRAMMAR_POOL_TIME_STAMP_KEY = Key.create((String)"GrammarPoolTimeStampKey");
    private static final Key<VirtualFile[]> DEPENDENT_FILES_KEY = Key.create((String)"GrammarPoolFilesKey");
    private static final Key<String[]> KNOWN_NAMESPACES_KEY = Key.create((String)"KnownNamespacesKey");
    private static final Key<XMLEntityManager> ENTITY_MANAGER_KEY = Key.create((String)"EntityManagerKey");
    private Project myProject;
    private XmlFile myFile;
    private ErrorReporter myErrorReporter;
    private SAXParser myParser;
    private XmlResourceResolver myXmlResourceResolver;
    private final boolean myForceChecking;
    @NonNls
    private static final String ENTITY_RESOLVER_PROPERTY_NAME = "http://apache.org/xml/properties/internal/entity-resolver";

    public ValidateXmlActionHandler(boolean _forceChecking) {
        this.myForceChecking = _forceChecking;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.myErrorReporter = errorReporter;
    }

    public VirtualFile getProblemFile(SAXParseException ex) {
        String publicId = ex.getPublicId();
        String systemId = ex.getSystemId();
        if (publicId == null) {
            if (systemId != null) {
                VirtualFile file2;
                if (systemId.startsWith("file:/") && (file2 = VirtualFileManager.getInstance().findFileByUrl(systemId.startsWith("file://") ? systemId : systemId.replace("file:/", "file://"))) != null) {
                    return file2;
                }
                String path = this.myXmlResourceResolver.getPathByPublicId(systemId);
                if (path != null) {
                    return UriUtil.findRelativeFile((String)path, null);
                }
                PsiFile file3 = this.myXmlResourceResolver.resolve(null, systemId);
                if (file3 != null) {
                    return file3.getVirtualFile();
                }
            }
            return this.myFile.getVirtualFile();
        }
        String path = this.myXmlResourceResolver.getPathByPublicId(publicId);
        if (path != null) {
            return UriUtil.findRelativeFile((String)path, null);
        }
        return null;
    }

    public String buildMessageString(SAXParseException ex) {
        String msg = "(" + ex.getLineNumber() + ":" + ex.getColumnNumber() + ") " + ex.getMessage();
        VirtualFile file2 = this.getProblemFile(ex);
        if (file2 != null && !file2.equals(this.myFile.getVirtualFile())) {
            msg = file2.getName() + ":" + msg;
        }
        return msg;
    }

    public void doValidate(XmlFile file2) {
        this.myProject = file2.getProject();
        this.myFile = file2;
        this.myXmlResourceResolver = new XmlResourceResolver(this.myFile, this.myProject, this.myErrorReporter);
        this.myXmlResourceResolver.setStopOnUnDeclaredResource(this.myErrorReporter.isStopOnUndeclaredResource());
        try {
            try {
                this.myParser = this.createParser();
            }
            catch (Exception e) {
                this.filterAppException(e);
            }
            if (this.myParser == null) {
                return;
            }
            this.myErrorReporter.startProcessing();
        }
        catch (XmlResourceResolver.IgnoredResourceException e) {
        }
        catch (Exception exception) {
            this.filterAppException(exception);
        }
    }

    private void filterAppException(Exception exception) {
        if (!this.myErrorReporter.filterValidationException(exception)) {
            LOG.error((Throwable)exception);
        }
    }

    public void doParse() {
        try {
            this.myParser.parse(new InputSource(new StringReader(this.myFile.getText())), new DefaultHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    if (ValidateXmlActionHandler.this.myErrorReporter.isUniqueProblem(e)) {
                        ValidateXmlActionHandler.this.myErrorReporter.processError(e, ProblemType.WARNING);
                    }
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    if (ValidateXmlActionHandler.this.myErrorReporter.isUniqueProblem(e)) {
                        ValidateXmlActionHandler.this.myErrorReporter.processError(e, ProblemType.ERROR);
                    }
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    if (ValidateXmlActionHandler.this.myErrorReporter.isUniqueProblem(e)) {
                        ValidateXmlActionHandler.this.myErrorReporter.processError(e, ProblemType.FATAL);
                    }
                }

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    PsiFile psiFile = ValidateXmlActionHandler.this.myXmlResourceResolver.resolve(null, systemId);
                    if (psiFile == null) {
                        return null;
                    }
                    return new InputSource(new StringReader(psiFile.getText()));
                }

                @Override
                public void startDocument() throws SAXException {
                    super.startDocument();
                    ValidateXmlActionHandler.this.myParser.setProperty(ValidateXmlActionHandler.ENTITY_RESOLVER_PROPERTY_NAME, ValidateXmlActionHandler.this.myXmlResourceResolver);
                }
            });
            String[] resourcePaths = this.myXmlResourceResolver.getResourcePaths();
            if (resourcePaths.length > 0) {
                VirtualFile[] files = new VirtualFile[resourcePaths.length];
                for (int i = 0; i < resourcePaths.length; ++i) {
                    files[i] = UriUtil.findRelativeFile((String)resourcePaths[i], null);
                }
                this.myFile.putUserData(DEPENDENT_FILES_KEY, (Object)files);
                this.myFile.putUserData(GRAMMAR_POOL_TIME_STAMP_KEY, (Object)ValidateXmlActionHandler.calculateTimeStamp(files, this.myProject));
            }
            this.myFile.putUserData(KNOWN_NAMESPACES_KEY, (Object)ValidateXmlActionHandler.getNamespaces(this.myFile));
        }
        catch (SAXException e) {
            LOG.debug((Throwable)e);
        }
        catch (Exception exception) {
            this.filterAppException(exception);
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
    }

    protected SAXParser createParser() throws SAXException, ParserConfigurationException {
        if (!(this.needsDtdChecking() || this.needsSchemaChecking() || this.myForceChecking)) {
            return null;
        }
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        boolean schemaChecking = false;
        if (this.hasDtdDeclaration()) {
            factory.setValidating(true);
        }
        if (this.needsSchemaChecking()) {
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            try {
                factory.setXIncludeAware(true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            schemaChecking = true;
        }
        SAXParser parser = factory.newSAXParser();
        parser.setProperty(ENTITY_RESOLVER_PROPERTY_NAME, this.myXmlResourceResolver);
        if (schemaChecking) {
            XMLGrammarPool grammarPool = ValidateXmlActionHandler.getGrammarPool(this.myFile, this.myForceChecking);
            ValidateXmlActionHandler.configureEntityManager(this.myFile, parser);
            parser.getXMLReader().setProperty(GRAMMAR_FEATURE_ID, grammarPool);
        }
        try {
            if (schemaChecking) {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                parser.getXMLReader().setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
                if (Boolean.TRUE.equals(Boolean.getBoolean("idea.xml.honour.all.schema.locations"))) {
                    parser.getXMLReader().setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
                }
                parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", Boolean.TRUE);
                parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", Boolean.TRUE);
            }
            parser.getXMLReader().setFeature("http://apache.org/xml/features/warn-on-duplicate-entitydef", Boolean.TRUE);
            parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/unparsed-entity-checking", Boolean.FALSE);
        }
        catch (SAXNotRecognizedException ex) {
            LOG.info("Xml parser installation seems screwed", (Throwable)ex);
        }
        return parser;
    }

    public static XMLGrammarPool getGrammarPool(XmlFile file2, boolean forceChecking) {
        XMLGrammarPool previousGrammarPool = ValidateXmlActionHandler.getGrammarPool(file2);
        XMLGrammarPool grammarPool = null;
        if (!forceChecking && !ValidateXmlActionHandler.isValidationDependentFilesOutOfDate(file2)) {
            grammarPool = previousGrammarPool;
        }
        if (grammarPool == null) {
            ValidateXmlActionHandler.invalidateEntityManager(file2);
            grammarPool = new XMLGrammarPoolImpl();
            file2.putUserData(GRAMMAR_POOL_KEY, (Object)grammarPool);
        }
        return grammarPool;
    }

    @Nullable
    public static XMLGrammarPool getGrammarPool(XmlFile file2) {
        return (XMLGrammarPool)file2.getUserData(GRAMMAR_POOL_KEY);
    }

    public static boolean isValidationDependentFilesOutOfDate(XmlFile myFile) {
        long dependentFilesTimestamp;
        VirtualFile[] files = (VirtualFile[])myFile.getUserData(DEPENDENT_FILES_KEY);
        Long grammarPoolTimeStamp = (Long)myFile.getUserData(GRAMMAR_POOL_TIME_STAMP_KEY);
        Object[] ns = (String[])myFile.getUserData(KNOWN_NAMESPACES_KEY);
        if (!Arrays.equals(ns, ValidateXmlActionHandler.getNamespaces(myFile))) {
            return true;
        }
        return grammarPoolTimeStamp == null || files == null || (dependentFilesTimestamp = ValidateXmlActionHandler.calculateTimeStamp(files, myFile.getProject())) != grammarPoolTimeStamp;
    }

    private static void invalidateEntityManager(XmlFile file2) {
        file2.putUserData(ENTITY_MANAGER_KEY, null);
    }

    private static void configureEntityManager(XmlFile file2, SAXParser parser) throws SAXException {
        XMLEntityManager entityManager = (XMLEntityManager)file2.getUserData(ENTITY_MANAGER_KEY);
        if (entityManager != null) {
            parser.getXMLReader().setProperty(ENTITY_MANAGER_PROPERTY_ID, new XMLEntityManager(entityManager));
        } else {
            entityManager = (XMLEntityManager)parser.getXMLReader().getProperty(ENTITY_MANAGER_PROPERTY_ID);
            file2.putUserData(ENTITY_MANAGER_KEY, (Object)entityManager);
        }
    }

    private static String[] getNamespaces(XmlFile file2) {
        XmlTag rootTag = file2.getRootTag();
        if (rootTag == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return (String[])ContainerUtil.mapNotNull((Object[])rootTag.getAttributes(), attribute -> attribute.getValue(), (Object[])ArrayUtil.EMPTY_STRING_ARRAY);
    }

    private static long calculateTimeStamp(VirtualFile[] files, Project myProject) {
        long timestamp = 0L;
        for (VirtualFile file2 : files) {
            PsiFile psifile;
            if (file2 == null || !file2.isValid() || (psifile = PsiManager.getInstance((Project)myProject).findFile(file2)) == null || !psifile.isValid()) break;
            timestamp += psifile.getViewProvider().getModificationStamp();
        }
        return timestamp;
    }

    private boolean hasDtdDeclaration() {
        XmlDocument document2 = this.myFile.getDocument();
        if (document2 == null) {
            return false;
        }
        XmlProlog prolog = document2.getProlog();
        if (prolog == null) {
            return false;
        }
        XmlDoctype doctype = prolog.getDoctype();
        return doctype != null;
    }

    private boolean needsDtdChecking() {
        XmlDocument document2 = this.myFile.getDocument();
        if (document2 == null) {
            return false;
        }
        return document2.getProlog() != null && document2.getProlog().getDoctype() != null;
    }

    private boolean needsSchemaChecking() {
        XmlAttribute[] attributes;
        XmlDocument document2 = this.myFile.getDocument();
        if (document2 == null) {
            return false;
        }
        XmlTag rootTag = document2.getRootTag();
        if (rootTag == null) {
            return false;
        }
        for (XmlAttribute attribute : attributes = rootTag.getAttributes()) {
            if (!attribute.isNamespaceDeclaration()) continue;
            return true;
        }
        return false;
    }

    public static enum ProblemType {
        WARNING,
        ERROR,
        FATAL;

    }
}

