/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.paths.DynamicContextProvider;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.xml.util.AnchorReferenceImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnchorPathReferenceProvider
implements PathReferenceProvider {
    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
        String anchor;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/xml/util/AnchorPathReferenceProvider", "createReferences"));
        }
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/xml/util/AnchorPathReferenceProvider", "createReferences"));
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)psiElement);
        String elementText = psiElement.getText();
        int anchorOffset = elementText.indexOf(35);
        if (anchorOffset == -1) {
            return false;
        }
        boolean dynamic = AnchorPathReferenceProvider.isDynamic(psiElement, anchorOffset + 1, elementText);
        if (dynamic) {
            return false;
        }
        FileReference fileReference = null;
        if (range.getStartOffset() != anchorOffset && ((fileReference = AnchorPathReferenceProvider.findFileReference(references)) == null || fileReference.resolve() == null)) {
            return false;
        }
        int pos = elementText.indexOf(63, anchorOffset);
        try {
            int endIndex;
            int n = endIndex = pos != -1 ? pos : range.getEndOffset();
            if (endIndex <= anchorOffset) {
                endIndex = anchorOffset + 1;
            }
            anchor = elementText.substring(anchorOffset + 1, endIndex);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException(elementText, e);
        }
        AnchorReferenceImpl anchorReference = new AnchorReferenceImpl(anchor, fileReference, psiElement, anchorOffset + 1, soft);
        references.add(anchorReference);
        return false;
    }

    private static boolean isDynamic(PsiElement psiElement, int offset, String elementText) {
        for (DynamicContextProvider provider : (DynamicContextProvider[])Extensions.getExtensions(DynamicContextProvider.EP_NAME)) {
            int dynamicOffset = provider.getOffset(psiElement, offset, elementText);
            if (dynamicOffset == offset) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static FileReference findFileReference(List<PsiReference> references) {
        FileReference fileReference = null;
        for (PsiReference reference : references) {
            if (!(reference instanceof FileReference)) continue;
            fileReference = ((FileReference)reference).getFileReferenceSet().getLastReference();
            break;
        }
        return fileReference;
    }

    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/xml/util/AnchorPathReferenceProvider", "getPathReference"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/AnchorPathReferenceProvider", "getPathReference"));
        }
        return null;
    }
}

