/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.util.ArrayList;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;

public class XIncludeProvider
extends FileIncludeProvider {
    @Override
    @NotNull
    public String getId() {
        if ("XInclude" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XIncludeProvider", "getId"));
        }
        return "XInclude";
    }

    @Override
    public boolean acceptFile(VirtualFile file2) {
        return file2.getFileType() == XmlFileType.INSTANCE;
    }

    @Override
    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/intellij/xml/util/XIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)XmlFileType.INSTANCE);
    }

    @Override
    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        CharSequence contentAsText = content.getContentAsText();
        if (CharArrayUtil.indexOf((CharSequence)contentAsText, (CharSequence)"http://www.w3.org/2001/XInclude", (int)0) == -1) {
            if (FileIncludeInfo.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XIncludeProvider", "getIncludeInfos"));
            }
            return FileIncludeInfo.EMPTY;
        }
        final ArrayList infos = new ArrayList();
        NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)contentAsText), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){
            boolean isXInclude;

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                this.isXInclude = "http://www.w3.org/2001/XInclude".equals(nsURI) && "include".equals(name);
            }

            public void addAttribute(String key2, String nsPrefix, String nsURI, String value, String type) throws Exception {
                if (this.isXInclude && "href".equals(key2)) {
                    infos.add(new FileIncludeInfo(value));
                }
            }

            public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
                this.isXInclude = false;
            }
        });
        FileIncludeInfo[] fileIncludeInfoArray = infos.toArray(new FileIncludeInfo[infos.size()]);
        if (fileIncludeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XIncludeProvider", "getIncludeInfos"));
        }
        return fileIncludeInfoArray;
    }
}

