/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaFileTypeManager
implements ProjectManagerListener {
    private final Map<Project, Collection<VirtualFile>> myFileSets = new ConcurrentHashMap<Project, Collection<VirtualFile>>();
    private volatile boolean mySetsInitialized;
    private static final Object LOCK = new Object();

    public static JsonSchemaFileTypeManager getInstance() {
        return (JsonSchemaFileTypeManager)ServiceManager.getService(JsonSchemaFileTypeManager.class);
    }

    public boolean isJsonSchemaFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/JsonSchemaFileTypeManager", "isJsonSchemaFile"));
        }
        this.ensureInitialized();
        for (Collection<VirtualFile> files : this.myFileSets.values()) {
            if (!files.contains(file2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        if (this.mySetsInitialized) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            Project[] openProjects;
            if (this.mySetsInitialized) {
                return;
            }
            for (Project openProject : openProjects = ProjectManager.getInstance().getOpenProjects()) {
                this.addProjectFiles(openProject);
            }
            this.mySetsInitialized = true;
        }
    }

    private Set<VirtualFile> addProjectFiles(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaFileTypeManager", "addProjectFiles"));
        }
        Set<VirtualFile> files = JsonSchemaService.Impl.getEx(project2).getSchemaFiles();
        this.myFileSets.put(project2, files);
        return files;
    }

    public void projectOpened(Project project2) {
        JsonSchemaFileTypeManager.reparseFiles(this.addProjectFiles(project2));
    }

    public void reset(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaFileTypeManager", "reset"));
        }
        Collection<VirtualFile> files = this.myFileSets.remove(project2);
        JsonSchemaFileTypeManager.reparseFiles(files);
    }

    private static void reparseFiles(Collection<VirtualFile> files) {
        if (files != null && !files.isEmpty()) {
            FileContentUtilCore.reparseFiles(files);
        }
    }

    public boolean canCloseProject(Project project2) {
        return true;
    }

    public void projectClosed(Project project2) {
        this.myFileSets.remove(project2);
    }

    public void projectClosing(Project project2) {
    }
}

