/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNullLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonBySchemaObjectAnnotator
implements Annotator {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.jsonSchema.JsonBySchemaAnnotator");
    private static final Key<Set<PsiElement>> ANNOTATED_PROPERTIES = Key.create((String)"JsonSchema.Properties.Annotated");
    private static final JsonSchemaObject ANY_SCHEMA = new JsonSchemaObject();
    private final JsonSchemaObject myRootSchema;

    public JsonBySchemaObjectAnnotator(@NotNull JsonSchemaObject schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "<init>"));
        }
        this.myRootSchema = schema;
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "annotate"));
        }
        PsiFile psiFile = element.getContainingFile();
        if (!(psiFile instanceof JsonFile)) {
            return;
        }
        final JsonProperty firstProp = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        if (firstProp == null) {
            this.checkRootObject(holder, element);
            return;
        }
        if (JsonBySchemaObjectAnnotator.checkIfAlreadyProcessed(holder, firstProp)) {
            return;
        }
        final ArrayList checkers = new ArrayList();
        JsonSchemaWalker.findSchemasForAnnotation(firstProp, new JsonSchemaWalker.CompletionSchemesConsumer(){

            @Override
            public void consume(boolean isName, @NotNull JsonSchemaObject schema) {
                if (schema == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$1", "consume"));
                }
                BySchemaChecker checker = new BySchemaChecker();
                HashSet validatedProperties = new HashSet();
                checker.checkByScheme(firstProp.getValue(), schema, validatedProperties);
                checkers.add(checker);
            }
        }, this.myRootSchema);
        if (checkers.isEmpty()) {
            return;
        }
        BySchemaChecker checker = null;
        if (checkers.size() == 1) {
            checker = (BySchemaChecker)checkers.get(0);
        } else {
            for (BySchemaChecker schemaChecker : checkers) {
                if (schemaChecker.isHadTypeError()) continue;
                checker = schemaChecker;
                break;
            }
            if (checker == null) {
                checker = (BySchemaChecker)checkers.get(0);
            }
        }
        if (JsonBySchemaObjectAnnotator.processCheckerResults(holder, checker)) {
            return;
        }
        if (firstProp.getParent() instanceof JsonObject && firstProp.getParent().getParent() instanceof PsiFile) {
            this.checkRootObject(holder, element);
        }
    }

    private void checkRootObject(@NotNull AnnotationHolder holder, PsiElement property) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "checkRootObject"));
        }
        JsonObject object = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)property, JsonObject.class);
        if (object != null) {
            BySchemaChecker rootChecker = new BySchemaChecker();
            HashSet validatedProperties = new HashSet();
            rootChecker.checkByScheme(object, this.myRootSchema, validatedProperties);
            JsonBySchemaObjectAnnotator.processCheckerResults(holder, rootChecker);
        }
    }

    private static boolean checkIfAlreadyProcessed(@NotNull AnnotationHolder holder, PsiElement property) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "checkIfAlreadyProcessed"));
        }
        AnnotationSession session2 = holder.getCurrentAnnotationSession();
        HashSet<PsiElement> data = (HashSet<PsiElement>)session2.getUserData(ANNOTATED_PROPERTIES);
        if (data == null) {
            data = new HashSet<PsiElement>();
            session2.putUserData(ANNOTATED_PROPERTIES, data);
        }
        if (data.contains(property)) {
            return true;
        }
        data.add(property);
        return false;
    }

    private static boolean processCheckerResults(@NotNull AnnotationHolder holder, BySchemaChecker checker) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "processCheckerResults"));
        }
        if (!checker.isCorrect()) {
            for (Map.Entry<PsiElement, String> entry : checker.getErrors().entrySet()) {
                if (JsonBySchemaObjectAnnotator.checkIfAlreadyProcessed(holder, entry.getKey())) continue;
                holder.createWarningAnnotation(entry.getKey(), entry.getValue());
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static JsonSchemaType matchSchemaType(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType input) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "matchSchemaType"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "matchSchemaType"));
        }
        if (schema.getType() != null) {
            JsonSchemaType matchType = schema.getType();
            if (matchType == input) {
                return matchType;
            }
            if (input == JsonSchemaType._integer && matchType == JsonSchemaType._number) {
                return JsonSchemaType._number;
            }
        }
        if (schema.getTypeVariants() != null) {
            List<JsonSchemaType> matchTypes = schema.getTypeVariants();
            if (matchTypes.contains((Object)input)) {
                return input;
            }
            if (input == JsonSchemaType._integer && matchTypes.contains((Object)JsonSchemaType._number)) {
                return JsonSchemaType._number;
            }
        }
        return null;
    }

    @Nullable
    private static JsonSchemaType getType(JsonValue value) {
        if (value instanceof JsonNullLiteral) {
            return JsonSchemaType._null;
        }
        if (value instanceof JsonBooleanLiteral) {
            return JsonSchemaType._boolean;
        }
        if (value instanceof JsonStringLiteral) {
            return JsonSchemaType._string;
        }
        if (value instanceof JsonArray) {
            return JsonSchemaType._array;
        }
        if (value instanceof JsonObject) {
            return JsonSchemaType._object;
        }
        if (value instanceof JsonNumberLiteral) {
            return JsonBySchemaObjectAnnotator.isInteger(value.getText()) ? JsonSchemaType._integer : JsonSchemaType._number;
        }
        return null;
    }

    private static boolean isInteger(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator", "isInteger"));
        }
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Nullable
    private static JsonSchemaObject getChild(JsonSchemaObject current, String name) {
        JsonSchemaObject notChild;
        JsonSchemaObject schema = current.getProperties().get(name);
        if (schema != null) {
            return schema;
        }
        schema = JsonBySchemaObjectAnnotator.getChildFromList(name, current.getAnyOf());
        if (schema != null) {
            return schema;
        }
        schema = JsonBySchemaObjectAnnotator.getChildFromList(name, current.getOneOf());
        if (schema != null) {
            return schema;
        }
        JsonSchemaObject not = current.getNot();
        if (not != null && (notChild = JsonBySchemaObjectAnnotator.getChild(not, name)) != null) {
            return null;
        }
        if (Boolean.TRUE.equals(current.getAdditionalPropertiesAllowed())) {
            schema = current.getAdditionalPropertiesSchema();
            if (schema == null) {
                return ANY_SCHEMA;
            }
            return schema;
        }
        return null;
    }

    @Nullable
    private static JsonSchemaObject getChildFromList(String name, List<JsonSchemaObject> of) {
        if (of == null) {
            return null;
        }
        for (JsonSchemaObject object : of) {
            JsonSchemaObject schema = JsonBySchemaObjectAnnotator.getChild(object, name);
            if (schema == null) continue;
            return schema;
        }
        return null;
    }

    private static class BySchemaChecker {
        private final Map<PsiElement, String> myErrors = new HashMap<PsiElement, String>();
        private boolean myHadTypeError;

        public Map<PsiElement, String> getErrors() {
            return this.myErrors;
        }

        public boolean isHadTypeError() {
            return this.myHadTypeError;
        }

        private void error(String error, PsiElement holder) {
            if (this.myErrors.containsKey(holder)) {
                return;
            }
            this.myErrors.put(holder, error);
        }

        private void typeError(@NotNull JsonValue value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "typeError"));
            }
            this.error("Type is not allowed", value);
            this.myHadTypeError = true;
        }

        private void checkByScheme(JsonValue value, JsonSchemaObject schema, Set<String> validatedProperties) {
            JsonSchemaType type;
            if (value == null) {
                return;
            }
            if (schema.getAnyOf() != null && !schema.getAnyOf().isEmpty()) {
                this.processAnyOf(value, schema, validatedProperties);
            }
            if (schema.getOneOf() != null && !schema.getOneOf().isEmpty()) {
                this.processOneOf(value, schema, validatedProperties);
            }
            if (schema.getAllOf() != null && !schema.getAllOf().isEmpty()) {
                this.processAllOf(value, schema, validatedProperties);
            }
            if ((type = JsonBySchemaObjectAnnotator.getType(value)) == null) {
                this.typeError(value);
                return;
            }
            JsonSchemaType schemaType = JsonBySchemaObjectAnnotator.matchSchemaType(schema, type);
            if (schemaType == null && schema.hasSpecifiedType()) {
                this.typeError(value);
                return;
            }
            if (JsonSchemaType._boolean.equals((Object)type)) {
                this.checkForEnum(value, schema);
                return;
            }
            if (JsonSchemaType._number.equals((Object)type) || JsonSchemaType._integer.equals((Object)type)) {
                this.checkNumber(value, schema, schemaType);
                this.checkForEnum(value, schema);
                return;
            }
            if (JsonSchemaType._string.equals((Object)type)) {
                this.checkString(value, schema);
                this.checkForEnum(value, schema);
                return;
            }
            if (JsonSchemaType._array.equals((Object)type)) {
                this.checkArray(value, schema);
                this.checkForEnum(value, schema);
                return;
            }
            if (JsonSchemaType._object.equals((Object)type)) {
                this.checkObject(value, schema, validatedProperties);
                this.checkForEnum(value, schema);
                return;
            }
            if (JsonSchemaType._null.equals((Object)type)) {
                return;
            }
        }

        private void checkObject(JsonValue value, JsonSchemaObject schema, Set<String> validatedProperties) {
            Map<String, JsonSchemaObject> map;
            Map<String, List<String>> map2;
            Map<String, JsonSchemaObject> properties = schema.getProperties();
            JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
            List<JsonProperty> propertyList = object.getPropertyList();
            HashMap<String, JsonProperty> map3 = new HashMap<String, JsonProperty>();
            for (JsonProperty jsonProperty : propertyList) {
                map3.put(jsonProperty.getName(), jsonProperty);
                JsonSchemaObject jsonSchemaObject = properties.get(jsonProperty.getName());
                if (jsonSchemaObject != null) {
                    this.checkByScheme(jsonProperty.getValue(), jsonSchemaObject, new HashSet<String>());
                } else if (schema.getAdditionalPropertiesSchema() != null) {
                    this.checkByScheme(jsonProperty.getValue(), schema.getAdditionalPropertiesSchema(), new HashSet<String>());
                } else if (!Boolean.TRUE.equals(schema.getAdditionalPropertiesAllowed()) && !validatedProperties.contains(jsonProperty.getName())) {
                    this.error("Property '" + jsonProperty.getName() + "' is not allowed", jsonProperty);
                }
                validatedProperties.add(jsonProperty.getName());
            }
            List<String> required = schema.getRequired();
            if (required != null) {
                for (String string : required) {
                    if (map3.containsKey(string)) continue;
                    this.error("Missing required property '" + string + "'", value);
                }
            }
            if (schema.getMinProperties() != null && map3.size() < schema.getMinProperties()) {
                this.error("Number of properties is less than " + schema.getMinProperties(), value);
            }
            if (schema.getMaxProperties() != null && map3.size() > schema.getMaxProperties()) {
                this.error("Number of properties is greater than " + schema.getMaxProperties(), value);
            }
            if ((map2 = schema.getPropertyDependencies()) != null) {
                for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
                    if (!map3.containsKey(entry.getKey())) continue;
                    List<String> list = entry.getValue();
                    for (String s : list) {
                        if (map3.containsKey(s)) continue;
                        this.error("Dependency is violated: '" + s + "' must be specified, since '" + entry.getKey() + "' is specified", value);
                    }
                }
            }
            if ((map = schema.getSchemaDependencies()) != null) {
                for (Map.Entry<String, JsonSchemaObject> entry : map.entrySet()) {
                    if (!map3.containsKey(entry.getKey())) continue;
                    this.checkByScheme(value, entry.getValue(), new HashSet<String>());
                }
            }
        }

        private boolean checkForEnum(JsonValue value, JsonSchemaObject schema) {
            if (schema.getEnum() == null) {
                return true;
            }
            String text = value.getText();
            List<Object> objects = schema.getEnum();
            for (Object object : objects) {
                if (!object.toString().equalsIgnoreCase(text)) continue;
                return true;
            }
            this.error("Value should be one of: [" + StringUtil.join(objects, o -> o.toString(), (String)", ") + "]", value);
            return false;
        }

        private void checkArray(JsonValue value, JsonSchemaObject schema) {
            JsonArray array = (JsonArray)ObjectUtils.tryCast((Object)value, JsonArray.class);
            List<JsonValue> list = array.getValueList();
            if (schema.getMinLength() != null && list.size() < schema.getMinLength()) {
                this.error("Array is shorter than " + schema.getMinLength(), array);
                return;
            }
            new ArrayItemsChecker().check(array, list, schema);
        }

        private void checkString(JsonValue propValue, JsonSchemaObject schema) {
            String value = StringUtil.unquoteString((String)propValue.getText());
            if (schema.getMinLength() != null && value.length() < schema.getMinLength()) {
                this.error("String is shorter than " + schema.getMinLength(), propValue);
                return;
            }
            if (schema.getMaxLength() != null && value.length() > schema.getMaxLength()) {
                this.error("String is longer than " + schema.getMaxLength(), propValue);
                return;
            }
        }

        private void checkNumber(JsonValue propValue, JsonSchemaObject schema, JsonSchemaType schemaType) {
            double leftOver;
            Number value;
            if (JsonSchemaType._integer.equals((Object)schemaType)) {
                try {
                    value = Integer.valueOf(propValue.getText());
                }
                catch (NumberFormatException e) {
                    this.error("Integer value expected", propValue);
                    return;
                }
            }
            try {
                value = Double.valueOf(propValue.getText());
            }
            catch (NumberFormatException e) {
                this.error("Double value expected", propValue);
                return;
            }
            if (schema.getMultipleOf() != null && (leftOver = value.doubleValue() % schema.getMultipleOf().doubleValue()) > 1.0E-6) {
                this.error("Is not multiple of " + propValue.getText(), propValue);
                return;
            }
            if (schema.getMinimum() != null) {
                this.checkMinimum(schema, value, propValue, schemaType);
            }
            if (schema.getMaximum() != null) {
                this.checkMaximum(schema, value, propValue, schemaType);
            }
        }

        private void checkMaximum(JsonSchemaObject schema, Number value, JsonValue propertyValue, @NotNull JsonSchemaType propValueType) {
            if (propValueType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propValueType", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "checkMaximum"));
            }
            if (JsonSchemaType._integer.equals((Object)propValueType)) {
                int intValue = schema.getMaximum().intValue();
                if (Boolean.TRUE.equals(schema.isExclusiveMaximum())) {
                    if (value.intValue() >= intValue) {
                        this.error("Greater than an exclusive maximum " + intValue, propertyValue);
                    }
                } else if (value.intValue() > intValue) {
                    this.error("Greater than a maximum " + intValue, propertyValue);
                }
            } else {
                double doubleValue = schema.getMaximum().doubleValue();
                if (Boolean.TRUE.equals(schema.isExclusiveMaximum())) {
                    if (value.doubleValue() >= doubleValue) {
                        this.error("Greater than an exclusive maximum " + schema.getMinimum(), propertyValue);
                    }
                } else if (value.doubleValue() > doubleValue) {
                    this.error("Greater than a maximum " + schema.getMaximum(), propertyValue);
                }
            }
        }

        private void checkMinimum(JsonSchemaObject schema, Number value, JsonValue propertyValue, @NotNull JsonSchemaType schemaType) {
            if (schemaType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaType", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectAnnotator$BySchemaChecker", "checkMinimum"));
            }
            if (JsonSchemaType._integer.equals((Object)schemaType)) {
                int intValue = schema.getMinimum().intValue();
                if (Boolean.TRUE.equals(schema.isExclusiveMinimum())) {
                    if (value.intValue() <= intValue) {
                        this.error("Less than an exclusive minimum " + intValue, propertyValue);
                    }
                } else if (value.intValue() < intValue) {
                    this.error("Less than a minimum " + intValue, propertyValue);
                }
            } else {
                double doubleValue = schema.getMinimum().doubleValue();
                if (Boolean.TRUE.equals(schema.isExclusiveMinimum())) {
                    if (value.doubleValue() <= doubleValue) {
                        this.error("Less than an exclusive minimum " + schema.getMinimum(), propertyValue);
                    }
                } else if (value.doubleValue() < doubleValue) {
                    this.error("Less than a minimum " + schema.getMinimum(), propertyValue);
                }
            }
        }

        private void processAllOf(JsonValue value, JsonSchemaObject schema, Set<String> validatedProperties) {
            List<JsonSchemaObject> allOf = schema.getAllOf();
            for (JsonSchemaObject object : allOf) {
                this.checkByScheme(value, object, validatedProperties);
            }
        }

        private void processOneOf(JsonValue value, JsonSchemaObject schema, Set<String> validatedProperties) {
            List<JsonSchemaObject> oneOf = schema.getOneOf();
            HashMap<PsiElement, String> errors = new HashMap<PsiElement, String>();
            int cntCorrect = 0;
            boolean validatedPropertiesAdded = false;
            for (JsonSchemaObject jsonSchemaObject : oneOf) {
                BySchemaChecker checker = new BySchemaChecker();
                HashSet<String> local = new HashSet<String>();
                checker.checkByScheme(value, jsonSchemaObject, local);
                if (checker.isCorrect()) {
                    if (!validatedPropertiesAdded) {
                        validatedPropertiesAdded = true;
                        validatedProperties.addAll(local);
                    }
                    ++cntCorrect;
                    continue;
                }
                if (!errors.isEmpty() && checker.getErrors().containsKey(value)) continue;
                errors.clear();
                errors.putAll(checker.getErrors());
            }
            if (cntCorrect == 1) {
                return;
            }
            if (cntCorrect > 0) {
                this.error("Validates to more than one variant", value);
            } else if (!errors.isEmpty()) {
                for (Map.Entry entry : errors.entrySet()) {
                    this.error((String)entry.getValue(), (PsiElement)entry.getKey());
                }
            }
        }

        private void processAnyOf(JsonValue value, JsonSchemaObject schema, Set<String> validatedProperties) {
            List<JsonSchemaObject> anyOf = schema.getAnyOf();
            HashMap<PsiElement, String> errors = new HashMap<PsiElement, String>();
            for (JsonSchemaObject jsonSchemaObject : anyOf) {
                BySchemaChecker checker = new BySchemaChecker();
                HashSet<String> local = new HashSet<String>();
                checker.checkByScheme(value, jsonSchemaObject, local);
                if (checker.isCorrect()) {
                    validatedProperties.addAll(local);
                    return;
                }
                if (!errors.isEmpty() || checker.getErrors().containsKey(value)) continue;
                errors.clear();
                errors.putAll(checker.getErrors());
            }
            if (!errors.isEmpty()) {
                for (Map.Entry entry : errors.entrySet()) {
                    this.error((String)entry.getValue(), (PsiElement)entry.getKey());
                }
            }
        }

        private boolean isCorrect() {
            return this.myErrors.isEmpty();
        }

        private class ArrayItemsChecker {
            private final Set<String> myValueTexts = new HashSet<String>();
            private JsonValue myFirstNonUnique;
            private boolean myCheckUnique;

            private ArrayItemsChecker() {
            }

            public void check(JsonArray array, List<JsonValue> list, JsonSchemaObject schema) {
                this.myCheckUnique = schema.isUniqueItems();
                if (schema.getItemsSchema() != null) {
                    for (JsonValue arrayValue : list) {
                        BySchemaChecker.this.checkByScheme(arrayValue, schema.getItemsSchema(), new HashSet());
                        this.checkUnique(arrayValue);
                    }
                } else if (schema.getItemsSchemaList() != null) {
                    Iterator<JsonSchemaObject> iterator = schema.getItemsSchemaList().iterator();
                    for (JsonValue arrayValue : list) {
                        if (iterator.hasNext()) {
                            BySchemaChecker.this.checkByScheme(arrayValue, iterator.next(), new HashSet());
                        } else if (!Boolean.TRUE.equals(schema.getAdditionalItemsAllowed())) {
                            BySchemaChecker.this.error("Additional items are not allowed", arrayValue);
                            return;
                        }
                        this.checkUnique(arrayValue);
                    }
                } else {
                    for (JsonValue arrayValue : list) {
                        this.checkUnique(arrayValue);
                    }
                }
                if (this.myFirstNonUnique != null) {
                    BySchemaChecker.this.error("Item is not unique", this.myFirstNonUnique);
                    return;
                }
                if (schema.getMinItems() != null && list.size() < schema.getMinItems()) {
                    BySchemaChecker.this.error("Array is shorter than " + schema.getMinItems(), array);
                    return;
                }
                if (schema.getMaxItems() != null && list.size() > schema.getMaxItems()) {
                    BySchemaChecker.this.error("Array is longer than " + schema.getMaxItems(), array);
                }
            }

            private void checkUnique(JsonValue arrayValue) {
                if (this.myCheckUnique && this.myFirstNonUnique == null && this.myValueTexts.contains(arrayValue.getText())) {
                    this.myFirstNonUnique = arrayValue;
                } else {
                    this.myValueTexts.add(arrayValue.getText());
                }
            }
        }
    }
}

