/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class LoopStatementsThatDontLoopInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("LoopStatementThatDoesntLoop" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection", "getID"));
        }
        return "LoopStatementThatDoesntLoop";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("loop.statements.that.dont.loop.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("loop.statements.that.dont.loop.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoopStatementsThatDontLoopVisitor();
    }

    private static class LoopStatementsThatDontLoopVisitor
    extends BaseInspectionVisitor {
        private LoopStatementsThatDontLoopVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection$LoopStatementsThatDontLoopVisitor", "visitForStatement"));
            }
            super.visitForStatement(statement2);
            PsiStatement body = statement2.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection$LoopStatementsThatDontLoopVisitor", "visitForeachStatement"));
            }
            super.visitForeachStatement(statement2);
            PsiStatement body = statement2.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection$LoopStatementsThatDontLoopVisitor", "visitWhileStatement"));
            }
            super.visitWhileStatement(statement2);
            PsiStatement body = statement2.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/LoopStatementsThatDontLoopInspection$LoopStatementsThatDontLoopVisitor", "visitDoWhileStatement"));
            }
            super.visitDoWhileStatement(statement2);
            PsiStatement body = statement2.getBody();
            if (body == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }
    }
}

