/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.Nullable;

public class NonNlsUtils {
    private static final Key<Boolean> KEY = new Key("IG_NON_NLS_ANNOTATED_USE");

    private NonNlsUtils() {
    }

    @Nullable
    public static PsiModifierListOwner getAnnotatableArgument(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression referenceExpression;
        PsiElement element;
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length < 1) {
            return null;
        }
        PsiExpression argument = arguments[0];
        if (argument instanceof PsiReferenceExpression && (element = (referenceExpression = (PsiReferenceExpression)argument).resolve()) instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)element;
        }
        return null;
    }

    @Nullable
    public static PsiModifierListOwner getAnnotatableQualifier(PsiReferenceExpression expression) {
        PsiReferenceExpression referenceExpression;
        PsiElement element;
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression instanceof PsiReferenceExpression && (element = (referenceExpression = (PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)element;
        }
        return null;
    }

    public static boolean isNonNlsAnnotated(@Nullable PsiExpression expression) {
        if (NonNlsUtils.isReferenceToNonNlsAnnotatedElement(expression)) {
            return true;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (NonNlsUtils.isNonNlsAnnotatedModifierListOwner((PsiElement)method)) {
                return true;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return NonNlsUtils.isNonNlsAnnotated(qualifier);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            return NonNlsUtils.isNonNlsAnnotated(arrayExpression);
        }
        return false;
    }

    public static boolean isNonNlsAnnotatedUse(@Nullable PsiExpression expression) {
        boolean result2;
        if (expression == null) {
            return false;
        }
        Boolean value = NonNlsUtils.getCachedValue(expression, KEY);
        if (value != null) {
            return value;
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiExpressionList.class, PsiAssignmentExpression.class, PsiVariable.class, PsiReturnStatement.class});
        if (element instanceof PsiExpressionList) {
            PsiExpressionList expressionList = (PsiExpressionList)element;
            result2 = NonNlsUtils.isNonNlsAnnotatedParameter(expression, expressionList);
        } else if (element instanceof PsiVariable) {
            result2 = NonNlsUtils.isNonNlsAnnotatedModifierListOwner(element);
        } else if (element instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
            result2 = NonNlsUtils.isAssignmentToNonNlsAnnotatedVariable(assignmentExpression);
        } else if (element instanceof PsiReturnStatement) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            result2 = NonNlsUtils.isNonNlsAnnotatedModifierListOwner((PsiElement)method);
        } else {
            result2 = false;
        }
        NonNlsUtils.putCachedValue(expression, KEY, result2);
        return result2;
    }

    private static <T> void putCachedValue(PsiExpression expression, Key<T> key2, T value) {
        if (expression instanceof PsiBinaryExpression) {
            expression.putUserData(key2, value);
        }
    }

    @Nullable
    private static <T> T getCachedValue(PsiExpression expression, Key<T> key2) {
        PsiExpression rhs;
        Object data = expression.getUserData(key2);
        if (!(expression instanceof PsiBinaryExpression)) {
            return (T)data;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        PsiExpression lhs = binaryExpression.getLOperand();
        Object childData = null;
        if (lhs instanceof PsiBinaryExpression) {
            childData = lhs.getUserData(key2);
        }
        if (childData == null && (rhs = binaryExpression.getROperand()) instanceof PsiBinaryExpression) {
            childData = rhs.getUserData(key2);
        }
        if (childData != data) {
            expression.putUserData(key2, childData);
        }
        return (T)childData;
    }

    private static boolean isAssignmentToNonNlsAnnotatedVariable(PsiAssignmentExpression assignmentExpression) {
        PsiExpression lhs = assignmentExpression.getLExpression();
        return NonNlsUtils.isReferenceToNonNlsAnnotatedElement(lhs);
    }

    private static boolean isReferenceToNonNlsAnnotatedElement(@Nullable PsiExpression expression) {
        if (!(expression instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement target = referenceExpression.resolve();
        return NonNlsUtils.isNonNlsAnnotatedModifierListOwner(target);
    }

    private static boolean isNonNlsAnnotatedParameter(PsiExpression expression, PsiExpressionList expressionList) {
        PsiParameterList parameterList;
        PsiElement parent = expressionList.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            if (NonNlsUtils.isQualifierNonNlsAnnotated(methodCallExpression)) {
                return true;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            parameterList = method.getParameterList();
        } else if (parent instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)parent;
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor == null) {
                return false;
            }
            parameterList = constructor.getParameterList();
        } else {
            return false;
        }
        PsiExpression[] expressions = expressionList.getExpressions();
        int index = -1;
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression argument = expressions[i];
            if (!PsiTreeUtil.isAncestor((PsiElement)argument, (PsiElement)expression, (boolean)false)) continue;
            index = i;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        if (parameters.length == 0) {
            return false;
        }
        PsiParameter parameter = index < parameters.length ? parameters[index] : parameters[parameters.length - 1];
        return NonNlsUtils.isNonNlsAnnotatedModifierListOwner((PsiElement)parameter);
    }

    private static boolean isQualifierNonNlsAnnotated(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (NonNlsUtils.isReferenceToNonNlsAnnotatedElement(qualifier)) {
            return true;
        }
        if (qualifier instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression expression;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            if (MethodUtils.isChainable(method) && NonNlsUtils.isQualifierNonNlsAnnotated(expression = (PsiMethodCallExpression)qualifier)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isNonNlsAnnotatedModifierListOwner(@Nullable PsiElement element) {
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner variable = (PsiModifierListOwner)element;
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)variable, (String)"org.jetbrains.annotations.NonNls", (boolean)false, (boolean)false);
    }
}

