/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class AssertAsNameInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("AssertAsIdentifier" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AssertAsNameInspectionBase", "getID"));
        }
        return "AssertAsIdentifier";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.assert.as.identifier.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AssertAsNameInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.assert.as.identifier.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AssertAsNameInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertAsNameVisitor();
    }

    private static class AssertAsNameVisitor
    extends BaseInspectionVisitor {
        private AssertAsNameVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/jdk/AssertAsNameInspectionBase$AssertAsNameVisitor", "visitVariable"));
            }
            super.visitVariable(variable);
            String variableName = variable.getName();
            if (!"assert".equals(variableName)) {
                return;
            }
            this.registerVariableError(variable, new Object[0]);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/jdk/AssertAsNameInspectionBase$AssertAsNameVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            String name = method.getName();
            if (!"assert".equals(name)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/jdk/AssertAsNameInspectionBase$AssertAsNameVisitor", "visitClass"));
            }
            String name = aClass.getName();
            if (!"assert".equals(name)) {
                return;
            }
            PsiTypeParameterList params = aClass.getTypeParameterList();
            if (params != null) {
                params.accept((PsiElementVisitor)this);
            }
            this.registerClassError(aClass, new Object[0]);
        }

        public void visitTypeParameter(PsiTypeParameter parameter) {
            super.visitTypeParameter(parameter);
            String name = parameter.getName();
            if (!"assert".equals(name)) {
                return;
            }
            this.registerTypeParameterError(parameter, new Object[0]);
        }
    }
}

