/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ObjectInstantiationInEqualsHashCodeInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("object.instantiation.inside.equals.or.hashcode.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ObjectInstantiationInEqualsHashCodeInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)infos[0]), PsiMethod.class);
        assert (method != null);
        String string = InspectionGadgetsBundle.message("object.instantiation.inside.equals.or.hashcode.problem.descriptor", method.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ObjectInstantiationInEqualsHashCodeInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectInstantiationInEqualsHashCodeVisitor();
    }

    private static class ObjectInstantiationInEqualsHashCodeVisitor
    extends BaseInspectionVisitor {
        private ObjectInstantiationInEqualsHashCodeVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            if (!ExpressionUtils.hasStringType((PsiExpression)expression) || ExpressionUtils.isEvaluatedAtCompileTime((PsiExpression)expression)) {
                return;
            }
            if (!ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (!ObjectInstantiationInEqualsHashCodeVisitor.isInsideEqualsOrHashCode((PsiElement)expression)) {
                return;
            }
            this.registerNewExpressionError(expression, expression);
        }

        private static boolean isInsideEqualsOrHashCode(PsiElement element) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiAssertStatement.class, PsiThrowStatement.class});
            if (method == null) {
                return false;
            }
            return MethodUtils.isEquals(method) || MethodUtils.isHashCode(method) || MethodUtils.isCompareTo(method) || MethodUtils.isComparatorCompare(method);
        }
    }
}

