/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ArrayContentsAssignedVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean assigned;
    private final PsiVariable variable;

    ArrayContentsAssignedVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/ArrayContentsAssignedVisitor", "<init>"));
        }
        this.variable = variable;
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/psiutils/ArrayContentsAssignedVisitor", "visitAssignmentExpression"));
        }
        if (this.assigned) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression lhs = assignment.getLExpression();
        PsiExpression arrayExpression = ArrayContentsAssignedVisitor.getDeepArrayExpression(lhs);
        if (!(arrayExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
        PsiElement referent = referenceExpression.resolve();
        if (referent == null) {
            return;
        }
        if (referent.equals(this.variable)) {
            this.assigned = true;
        }
    }

    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ArrayContentsAssignedVisitor", "visitPrefixExpression"));
        }
        if (this.assigned) {
            return;
        }
        super.visitPrefixExpression(expression);
        IElementType tokenType = expression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = expression.getOperand();
        PsiExpression arrayExpression = ArrayContentsAssignedVisitor.getDeepArrayExpression(operand);
        if (!(arrayExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
        PsiElement referent = referenceExpression.resolve();
        if (referent == null) {
            return;
        }
        if (referent.equals(this.variable)) {
            this.assigned = true;
        }
    }

    public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ArrayContentsAssignedVisitor", "visitPostfixExpression"));
        }
        if (this.assigned) {
            return;
        }
        super.visitPostfixExpression(expression);
        IElementType tokenType = expression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = expression.getOperand();
        PsiExpression arrayExpression = ArrayContentsAssignedVisitor.getDeepArrayExpression(operand);
        if (!(arrayExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)arrayExpression;
        PsiElement referent = referenceExpression.resolve();
        if (referent == null) {
            return;
        }
        if (referent.equals(this.variable)) {
            this.assigned = true;
        }
    }

    @Nullable
    private static PsiExpression getDeepArrayExpression(PsiExpression expression) {
        if (!(expression instanceof PsiArrayAccessExpression)) {
            return null;
        }
        PsiExpression arrayExpression = ((PsiArrayAccessExpression)expression).getArrayExpression();
        while (arrayExpression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)arrayExpression;
            arrayExpression = arrayAccessExpression.getArrayExpression();
        }
        return arrayExpression;
    }

    public boolean isAssigned() {
        return this.assigned;
    }
}

