/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessarilyQualifiedStaticUsageInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_ignoreStaticFieldAccesses = false;
    public boolean m_ignoreStaticMethodCalls = false;
    public boolean m_ignoreStaticAccessFromStaticContext = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)infos[0];
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.problem.descriptor", element.getText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.problem.descriptor1", element.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.ignore.field.option", new Object[0]), "m_ignoreStaticFieldAccesses");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.ignore.method.option", new Object[0]), "m_ignoreStaticMethodCalls");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("only.report.qualified.static.usages.option", new Object[0]), "m_ignoreStaticAccessFromStaticContext");
        return optionsPanel;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessarilyQualifiedStaticUsageFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarilyQualifiedStaticUsageVisitor();
    }

    public static boolean isUnnecessarilyQualifiedAccess(@NotNull PsiJavaCodeReferenceElement referenceElement, boolean ignoreStaticAccessFromStaticContext, boolean ignoreStaticFieldAccesses, boolean ignoreStaticMethodCalls) {
        PsiClass memberClass;
        PsiMember containingMember;
        if (referenceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceElement", "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection", "isUnnecessarilyQualifiedAccess"));
        }
        if (referenceElement instanceof PsiMethodReferenceExpression) {
            return false;
        }
        PsiElement parent = referenceElement.getParent();
        if (parent instanceof PsiImportStatementBase) {
            return false;
        }
        PsiElement qualifierElement = referenceElement.getQualifier();
        if (!(qualifierElement instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiJavaCodeReferenceElement qualifier = (PsiJavaCodeReferenceElement)qualifierElement;
        if (UnnecessarilyQualifiedStaticUsageInspection.isGenericReference(referenceElement, qualifier)) {
            return false;
        }
        PsiElement target = referenceElement.resolve();
        if (!(target instanceof PsiField && !ignoreStaticFieldAccesses || target instanceof PsiMethod && !ignoreStaticMethodCalls)) {
            return false;
        }
        if (ignoreStaticAccessFromStaticContext && (containingMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiMember.class)) != null && !containingMember.hasModifierProperty("static")) {
            return false;
        }
        String referenceName = referenceElement.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        PsiElement resolvedQualifier = qualifier.resolve();
        if (!(resolvedQualifier instanceof PsiClass)) {
            return false;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiClass.class);
        PsiClass qualifyingClass = (PsiClass)resolvedQualifier;
        if (containingClass == null || !PsiTreeUtil.isAncestor((PsiElement)qualifyingClass, (PsiElement)containingClass, (boolean)false)) {
            return false;
        }
        Project project2 = referenceElement.getProject();
        JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)project2);
        PsiResolveHelper resolveHelper = manager.getResolveHelper();
        PsiMember member = (PsiMember)target;
        if (target instanceof PsiField) {
            PsiVariable variable = resolveHelper.resolveReferencedVariable(referenceName, (PsiElement)referenceElement);
            if (variable == null || !variable.equals(member)) {
                return false;
            }
            TextRange referenceElementTextRange = referenceElement.getTextRange();
            if (referenceElementTextRange == null) {
                return false;
            }
            TextRange variableTextRange = variable.getTextRange();
            if (variableTextRange == null) {
                return false;
            }
            if (referenceElementTextRange.getStartOffset() < variableTextRange.getEndOffset()) {
                return false;
            }
            PsiMember memberVariable = (PsiMember)variable;
            memberClass = memberVariable.getContainingClass();
        } else if (target instanceof PsiClass) {
            PsiClass aClass = resolveHelper.resolveReferencedClass(referenceName, (PsiElement)referenceElement);
            if (aClass == null || !aClass.equals(member)) {
                return false;
            }
            memberClass = aClass.getContainingClass();
        } else {
            return UnnecessarilyQualifiedStaticUsageInspection.isMethodAccessibleWithoutQualifier(referenceElement, qualifyingClass);
        }
        return resolvedQualifier.equals(memberClass);
    }

    private static boolean isMethodAccessibleWithoutQualifier(PsiJavaCodeReferenceElement referenceElement, PsiClass qualifyingClass) {
        String referenceName = referenceElement.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)referenceElement);
        while (containingClass != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = containingClass.findMethodsByName(referenceName, true)) {
                String name = method.getName();
                if (!referenceName.equals(name)) continue;
                return containingClass.equals(qualifyingClass);
            }
            containingClass = ClassUtils.getContainingClass((PsiElement)containingClass);
        }
        return false;
    }

    static boolean isGenericReference(PsiJavaCodeReferenceElement referenceElement, PsiJavaCodeReferenceElement qualifierElement) {
        PsiTypeElement[] typeParameterElements;
        PsiTypeElement[] typeParameterElements2;
        PsiReferenceParameterList qualifierParameterList = qualifierElement.getParameterList();
        if (qualifierParameterList != null && (typeParameterElements2 = qualifierParameterList.getTypeParameterElements()).length > 0) {
            return true;
        }
        PsiReferenceParameterList parameterList = referenceElement.getParameterList();
        return parameterList != null && (typeParameterElements = parameterList.getTypeParameterElements()).length > 0;
    }

    private class UnnecessarilyQualifiedStaticUsageVisitor
    extends BaseInspectionVisitor {
        private UnnecessarilyQualifiedStaticUsageVisitor() {
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            PsiElement qualifier = reference.getQualifier();
            if (qualifier == null) {
                return;
            }
            if (!UnnecessarilyQualifiedStaticUsageInspection.isUnnecessarilyQualifiedAccess(reference, UnnecessarilyQualifiedStaticUsageInspection.this.m_ignoreStaticAccessFromStaticContext, UnnecessarilyQualifiedStaticUsageInspection.this.m_ignoreStaticFieldAccesses, UnnecessarilyQualifiedStaticUsageInspection.this.m_ignoreStaticMethodCalls)) {
                return;
            }
            this.registerError(qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{reference});
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }
    }

    private static class UnnecessarilyQualifiedStaticUsageFix
    extends InspectionGadgetsFix {
        private UnnecessarilyQualifiedStaticUsageFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection$UnnecessarilyQualifiedStaticUsageFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection$UnnecessarilyQualifiedStaticUsageFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            element.delete();
        }
    }
}

