/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.increment;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.PsiElementPredicate;

class ExtractIncrementPredicate
implements PsiElementPredicate {
    ExtractIncrementPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        IElementType tokenType;
        PsiExpression operand;
        if (!(element instanceof PsiPrefixExpression) && !(element instanceof PsiPostfixExpression)) {
            return false;
        }
        if (element instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
            operand = postfixExpression.getOperand();
            if (!(operand instanceof PsiReferenceExpression)) {
                return false;
            }
            tokenType = postfixExpression.getOperationTokenType();
        } else {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
            operand = prefixExpression.getOperand();
            if (!(operand instanceof PsiReferenceExpression)) {
                return false;
            }
            tokenType = prefixExpression.getOperationTokenType();
        }
        if (!JavaTokenType.PLUSPLUS.equals(tokenType) && !JavaTokenType.MINUSMINUS.equals(tokenType)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiExpressionStatement) {
            return false;
        }
        PsiStatement containingStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        return containingStatement != null;
    }
}

