/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.opassign.ReplacePostfixExpressionWithOperatorAssignmentPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplacePostfixExpressionWithOperatorAssignmentIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
        PsiJavaToken sign = postfixExpression.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        String replacementText = JavaTokenType.PLUSPLUS.equals(tokenType) ? "+=" : "-=";
        String signText = sign.getText();
        return IntentionPowerPackBundle.message("replace.some.operator.with.other.intention.name", signText, replacementText);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ReplacePostfixExpressionWithOperatorAssignmentPredicate replacePostfixExpressionWithOperatorAssignmentPredicate = new ReplacePostfixExpressionWithOperatorAssignmentPredicate();
        if (replacePostfixExpressionWithOperatorAssignmentPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/opassign/ReplacePostfixExpressionWithOperatorAssignmentIntention", "getElementPredicate"));
        }
        return replacePostfixExpressionWithOperatorAssignmentPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/opassign/ReplacePostfixExpressionWithOperatorAssignmentIntention", "processIntention"));
        }
        PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
        PsiExpression operand = postfixExpression.getOperand();
        String operandText = operand.getText();
        IElementType tokenType = postfixExpression.getOperationTokenType();
        if (JavaTokenType.PLUSPLUS.equals(tokenType)) {
            PsiReplacementUtil.replaceExpression((PsiExpression)postfixExpression, operandText + "+=1");
        } else if (JavaTokenType.MINUSMINUS.equals(tokenType)) {
            PsiReplacementUtil.replaceExpression((PsiExpression)postfixExpression, operandText + "-=1");
        }
    }
}

