/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.types;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferLambdaParameterTypeIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)("#" + InferLambdaParameterTypeIntention.class.getName()));
    private String myInferredTypesText;

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        LambdaParametersPredicate lambdaParametersPredicate = new LambdaParametersPredicate();
        if (lambdaParametersPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/types/InferLambdaParameterTypeIntention", "getElementPredicate"));
        }
        return lambdaParametersPredicate;
    }

    @Override
    @NotNull
    public String getText() {
        String string = "Expand lambda to " + this.myInferredTypesText + " -> {...}";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/types/InferLambdaParameterTypeIntention", "getText"));
        }
        return string;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/types/InferLambdaParameterTypeIntention", "processIntention"));
        }
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
        LOG.assertTrue(lambdaExpression != null);
        PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
        String buf = InferLambdaParameterTypeIntention.getInferredTypes(functionalInterfaceType, lambdaExpression, true);
        Project project2 = element.getProject();
        PsiMethod methodFromText = JavaPsiFacade.getElementFactory((Project)project2).createMethodFromText("void foo" + buf, element);
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(lambdaExpression.getParameterList().replace((PsiElement)methodFromText.getParameterList()));
    }

    @Nullable
    private static String getInferredTypes(PsiType functionalInterfaceType, PsiLambdaExpression lambdaExpression, boolean useFQN) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        LOG.assertTrue(interfaceMethod != null);
        PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
        PsiParameter[] lambdaParameters = lambdaExpression.getParameterList().getParameters();
        if (parameters.length != lambdaParameters.length) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiType psiType = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult).substitute(parameter.getType());
            if (!PsiTypesUtil.isDenotableType((PsiType)psiType)) {
                return null;
            }
            if (psiType != null) {
                buf.append(useFQN ? psiType.getCanonicalText() : psiType.getPresentableText()).append(" ").append(lambdaParameters[i].getName());
            } else {
                buf.append(lambdaParameters[i].getName());
            }
            if (i >= parameters.length - 1) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    private class LambdaParametersPredicate
    implements PsiElementPredicate {
        private LambdaParametersPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
            if (lambdaExpression != null) {
                PsiType functionalInterfaceType;
                PsiParameter[] parameters = lambdaExpression.getParameterList().getParameters();
                if (parameters.length == 0) {
                    return false;
                }
                for (PsiParameter parameter : parameters) {
                    if (parameter.getTypeElement() == null) continue;
                    return false;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)lambdaExpression.getParameterList(), (PsiElement)element, (boolean)false) && (functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType()) != null && LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType) != null && LambdaUtil.isLambdaFullyInferred((PsiLambdaExpression)lambdaExpression, (PsiType)functionalInterfaceType)) {
                    InferLambdaParameterTypeIntention.this.myInferredTypesText = InferLambdaParameterTypeIntention.getInferredTypes(functionalInterfaceType, lambdaExpression, false);
                    return InferLambdaParameterTypeIntention.this.myInferredTypesText != null;
                }
            }
            return false;
        }
    }
}

