/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import java.text.MessageFormat;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncExternalRef;
import org.intellij.plugins.relaxNG.compact.psi.RncInclude;
import org.intellij.plugins.relaxNG.compact.psi.RncName;
import org.intellij.plugins.relaxNG.compact.psi.RncParentRef;
import org.intellij.plugins.relaxNG.compact.psi.RncRef;
import org.jetbrains.annotations.NotNull;

public class ReferenceAnnotator
extends RncElementVisitor
implements Annotator {
    private AnnotationHolder myHolder;

    public synchronized void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/intellij/plugins/relaxNG/compact/ReferenceAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/relaxNG/compact/ReferenceAnnotator", "annotate"));
        }
        this.myHolder = holder;
        try {
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitInclude(RncInclude include) {
        this.checkReferences(include.getReferences());
    }

    @Override
    public void visitExternalRef(RncExternalRef ref) {
        this.checkReferences(ref.getReferences());
    }

    @Override
    public void visitRef(RncRef pattern) {
        this.checkReferences(pattern.getReferences());
    }

    @Override
    public void visitParentRef(RncParentRef pattern) {
        this.checkReferences(pattern.getReferences());
    }

    @Override
    public void visitName(RncName name) {
        this.checkReferences(name.getReferences());
    }

    private void checkReferences(PsiReference[] references) {
        for (PsiReference reference : references) {
            if (reference.isSoft() || reference.resolve() != null) continue;
            if (reference instanceof PsiPolyVariantReference) {
                PsiPolyVariantReference pvr = (PsiPolyVariantReference)reference;
                if (pvr.multiResolve(false).length != 0) continue;
                this.addError(reference);
                continue;
            }
            this.addError(reference);
        }
    }

    private void addError(PsiReference reference) {
        LocalQuickFix[] fixes;
        Annotation annotation;
        TextRange rangeInElement = reference.getRangeInElement();
        TextRange range = TextRange.from((int)(reference.getElement().getTextRange().getStartOffset() + rangeInElement.getStartOffset()), (int)rangeInElement.getLength());
        if (reference instanceof EmptyResolveMessageProvider) {
            String s = ((EmptyResolveMessageProvider)reference).getUnresolvedMessagePattern();
            annotation = this.myHolder.createErrorAnnotation(range, MessageFormat.format(s, reference.getCanonicalText()));
        } else {
            annotation = this.myHolder.createErrorAnnotation(range, "Cannot resolve symbol");
        }
        annotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        if (reference instanceof LocalQuickFixProvider && (fixes = ((LocalQuickFixProvider)reference).getQuickFixes()) != null) {
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)reference.getElement().getProject());
            for (LocalQuickFix fix : fixes) {
                ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor(reference.getElement(), annotation.getMessage(), fix, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true);
                annotation.registerFix(fix, null, null, descriptor);
            }
        }
    }
}

