/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.util.XmlEnumeratedValueReference;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.model.descriptors.RngElementDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DAttributePattern;
import org.xml.sax.Locator;

public class RngXmlAttributeDescriptor
extends BasicXmlAttributeDescriptor {
    @NonNls
    private static final QName UNKNOWN = new QName("", "#unknown");
    private static final TObjectHashingStrategy<Locator> HASHING_STRATEGY = new TObjectHashingStrategy<Locator>(){

        public int computeHashCode(Locator o) {
            String s = o.getSystemId();
            return o.getLineNumber() * 31 + o.getColumnNumber() * 23 + (s != null ? s.hashCode() * 11 : 0);
        }

        public boolean equals(Locator o, Locator o1) {
            return o.getLineNumber() == o1.getLineNumber() && o.getColumnNumber() == o1.getColumnNumber() && Comparing.equal((String)o.getSystemId(), (String)o1.getSystemId());
        }
    };
    private final Map<String, String> myValues;
    private final boolean myOptional;
    private final RngElementDescriptor myElementDescriptor;
    private final THashSet<Locator> myDeclarations = new THashSet(HASHING_STRATEGY);
    private final QName myName;

    RngXmlAttributeDescriptor(RngElementDescriptor elementDescriptor, DAttributePattern pattern, Map<String, String> values, boolean optional) {
        this(elementDescriptor, RngXmlAttributeDescriptor.getName(pattern), values, optional, pattern.getLocation());
    }

    private static QName getName(DAttributePattern pattern) {
        Iterator iterator = pattern.getName().listNames().iterator();
        return iterator.hasNext() ? (QName)iterator.next() : UNKNOWN;
    }

    private RngXmlAttributeDescriptor(RngElementDescriptor elementDescriptor, QName name, Map<String, String> values, boolean optional, Locator ... locations) {
        this.myElementDescriptor = elementDescriptor;
        this.myValues = values;
        this.myOptional = optional;
        this.myName = name;
        this.myDeclarations.addAll(Arrays.asList(locations));
    }

    public RngXmlAttributeDescriptor mergeWith(RngXmlAttributeDescriptor d) {
        QName name = d.myName.equals(UNKNOWN) ? this.myName : d.myName;
        HashMap<String, String> values = new HashMap<String, String>(this.myValues);
        values.putAll(d.myValues);
        THashSet locations = new THashSet(this.myDeclarations, HASHING_STRATEGY);
        locations.addAll(d.myDeclarations);
        return new RngXmlAttributeDescriptor(this.myElementDescriptor, name, values, this.myOptional || d.myOptional, (Locator[])locations.toArray((Object[])new Locator[locations.size()]));
    }

    public boolean isRequired() {
        return !this.myOptional;
    }

    @Override
    public boolean isFixed() {
        return this.isEnumerated() && this.myValues.size() == 1;
    }

    public boolean hasIdType() {
        return this.myValues.values().contains("ID");
    }

    public boolean hasIdRefType() {
        return this.myValues.values().contains("IDREF");
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return this.isEnumerated() ? this.myValues.keySet().iterator().next() : null;
    }

    public boolean isEnumerated() {
        return this.myValues.size() > 0 && this.myValues.get(null) == null;
    }

    @Override
    public String[] getEnumeratedValues() {
        if (this.myValues.size() > 0) {
            Map<String, String> copy;
            if (this.myValues.get(null) != null) {
                copy = new HashMap<String, String>(this.myValues);
                copy.remove(null);
            } else {
                copy = this.myValues;
            }
            return copy.keySet().toArray(new String[copy.size()]);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public PsiElement getDeclaration() {
        Iterator it = this.myDeclarations.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return this.myElementDescriptor.getDeclaration((Locator)it.next());
    }

    public Collection<PsiElement> getDeclarations() {
        return ContainerUtil.map2List(this.myDeclarations, locator -> this.myElementDescriptor.getDeclaration((Locator)locator));
    }

    @Override
    public String getName(PsiElement context) {
        String prefix2;
        String uri;
        String prefix;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false, (Class[])new Class[]{PsiFile.class});
        if (tag != null && (prefix = tag.getPrefixByNamespace(uri = this.myName.getNamespaceURI())) != null) {
            if (prefix.length() == 0) {
                return this.myName.getLocalPart();
            }
            return prefix + ":" + this.myName.getLocalPart();
        }
        if (this.myName.getNamespaceURI().length() > 0 && (prefix2 = this.myName.getPrefix()) != null && prefix2.length() > 0) {
            return prefix2 + ":" + this.myName.getLocalPart();
        }
        return this.myName.getLocalPart();
    }

    @NonNls
    public String getName() {
        return this.myName.getLocalPart();
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return this.myElementDescriptor.getDependences();
    }

    @Override
    public String validateValue(XmlElement context, String value) {
        if (this.isTokenDatatype(value)) {
            value = RngXmlAttributeDescriptor.normalizeSpace(value);
        }
        return super.validateValue(context, value);
    }

    private boolean isTokenDatatype(String value) {
        if (this.myValues.containsKey(value)) {
            return "token".equals(this.myValues.get(value));
        }
        return this.myValues.containsKey(value = RngXmlAttributeDescriptor.normalizeSpace(value)) && "token".equals(this.myValues.get(value));
    }

    private static String normalizeSpace(String value) {
        return value.replaceAll("\\s+", " ").trim();
    }

    public PsiReference[] getValueReferences(XmlElement element, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/plugins/relaxNG/model/descriptors/RngXmlAttributeDescriptor", "getValueReferences"));
        }
        return new PsiReference[]{new XmlEnumeratedValueReference(element, this){

            @Override
            @Nullable
            public PsiElement resolve() {
                if (RngXmlAttributeDescriptor.this.isTokenDatatype(this.getValue())) {
                    return this.getElement();
                }
                return super.resolve();
            }
        }};
    }
}

