/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PrefixlessWebServerRootsProvider;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/builtInWebServer/ArtifactWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/PrefixlessWebServerRootsProvider;", "()V", "getPathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "resolve", "path", "", "resolver", "Lorg/jetbrains/builtInWebServer/FileResolver;", "compiler-impl"})
public final class ArtifactWebServerRootsProvider
extends PrefixlessWebServerRootsProvider {
    @Override
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project2, @NotNull FileResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        Artifact[] artifactArray = ArtifactManager.getInstance((Project)project2).getArtifacts();
        for (int i = 0; i < artifactArray.length; ++i) {
            VirtualFile root;
            Artifact artifact = artifactArray[i];
            VirtualFile virtualFile = artifact.getOutputFile();
            if (virtualFile == null) {
                continue;
            }
            VirtualFile virtualFile2 = root = virtualFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"root");
            return FileResolver.DefaultImpls.resolve$default(resolver, path, virtualFile2, null, false, 12, null);
        }
        return null;
    }

    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file2, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Artifact[] artifactArray = ArtifactManager.getInstance((Project)project2).getArtifacts();
        for (int i = 0; i < artifactArray.length; ++i) {
            VirtualFile root;
            Artifact artifact = artifactArray[i];
            if (artifact.getOutputFile() == null) {
                continue;
            }
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)true)) continue;
            Path path = null;
            VirtualFile virtualFile = root;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
            return new PathInfo(path, file2, virtualFile, null, false, false, 56, null);
        }
        return null;
    }
}

