/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DebuggableRunConfiguration
extends RunConfiguration {
    @NotNull
    default public InetSocketAddress computeDebugAddress(RunProfileState state) throws ExecutionException {
        InetSocketAddress inetSocketAddress;
        block2: {
            try {
                inetSocketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), NetUtils.findAvailableSocketPort());
                if (inetSocketAddress != null) break block2;
            }
            catch (IOException e) {
                throw new ExecutionException("Cannot find available port", (Throwable)e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/DebuggableRunConfiguration", "computeDebugAddress"));
        }
        return inetSocketAddress;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress var1, @NotNull XDebugSession var2, @Nullable ExecutionResult var3, @NotNull ExecutionEnvironment var4) throws ExecutionException;

    public static interface RunConfigurationWithConditionalRun {
        public boolean canRun(@NotNull String var1, @NotNull RunProfile var2);
    }
}

