/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.Value;

public class VariableImpl
implements Variable {
    protected volatile Value value;
    private final String name;
    private final ValueModifier valueModifier;

    public VariableImpl(@NotNull String name, @Nullable Value value, @Nullable ValueModifier valueModifier) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/VariableImpl", "<init>"));
        }
        this.name = name;
        this.value = value;
        this.valueModifier = valueModifier;
    }

    public VariableImpl(@NotNull String name, @NotNull Value value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/VariableImpl", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableImpl", "<init>"));
        }
        this(name, value, null);
    }

    @Override
    @Nullable
    public final ValueModifier getValueModifier() {
        return this.valueModifier;
    }

    @Override
    @NotNull
    public final String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableImpl", "getName"));
        }
        return string;
    }

    @Override
    @Nullable
    public final Value getValue() {
        return this.value;
    }

    @Override
    public void setValue(Value value) {
        this.value = value;
    }

    @Override
    public boolean isMutable() {
        return this.valueModifier != null;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    public String toString() {
        return "[Variable: name=" + this.getName() + ", value=" + this.getValue() + ']';
    }
}

