/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.actions.AndroidAssetStudioAction;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.npw.VectorAssetStudioWizard;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewVectorAssetAction
extends AndroidAssetStudioAction {
    private static final String ERROR_TITLE = "Newer Android Plugin for Gradle Required";
    private static final String ERROR_MESSAGE = "<html><p>To support vector assets when your minimal SDK version is less than 21,<br>the Android plugin for Gradle version must be 1.4 or above.<br>This will allow Android Studio to convert vector assets into PNG images at build time.</p><p>See <a href=\"https://developer.android.com/tools/building/plugin-for-gradle.html#projectBuildFile\">here</a> for how to update the version of Android plugin for Gradle.</p></html>";
    private static final GradleVersion VECTOR_ASSET_GENERATION_REVISION = new GradleVersion(1, 4, 0);
    private static final int VECTOR_DRAWABLE_API_LEVEL = 21;

    public NewVectorAssetAction() {
        super("Vector Asset", "Open Vector Asset Studio to create an image asset");
    }

    @Override
    protected void showWizardAndCreateAsset(@NotNull AndroidFacet facet, @Nullable VirtualFile targetFile) {
        VectorAssetStudioWizard dialog;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/actions/NewVectorAssetAction", "showWizardAndCreateAsset"));
        }
        Module module = facet.getModule();
        Project project = module.getProject();
        AndroidGradleModel androidModel = AndroidGradleModel.get(module);
        if (androidModel != null) {
            AndroidVersion minSdkVersion = androidModel.getMinSdkVersion();
            String version = androidModel.getAndroidProject().getModelVersion();
            GradleVersion revision = GradleVersion.parse((String)version);
            if (revision.compareIgnoringQualifiers(VECTOR_ASSET_GENERATION_REVISION) < 0 && (minSdkVersion == null || minSdkVersion.getApiLevel() < 21)) {
                Messages.showErrorDialog((Project)project, (String)ERROR_MESSAGE, (String)ERROR_TITLE);
                return;
            }
        }
        if (!(dialog = new VectorAssetStudioWizard(project, module, targetFile)).showAndGet()) {
            return;
        }
        dialog.createAssets();
    }
}

