/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.resources.Density;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.sdklib.devices.Multitouch;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.ScreenType;
import com.android.tools.idea.avdmanager.AvdDeviceData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AvdScreenData {
    private AvdDeviceData myDeviceData;

    public AvdScreenData(AvdDeviceData deviceData) {
        this.myDeviceData = deviceData;
    }

    public static double calculateDpi(double screenResolutionWidth, double screenResolutionHeight, double diagonalScreenSize) {
        double diagonalPixelResolution = Math.sqrt(Math.pow(screenResolutionWidth, 2.0) + Math.pow(screenResolutionHeight, 2.0));
        return diagonalPixelResolution / diagonalScreenSize;
    }

    @NotNull
    public static ScreenSize getScreenSize(@Nullable Double diagonalSize) {
        if (diagonalSize == null) {
            ScreenSize screenSize = ScreenSize.NORMAL;
            if (screenSize == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdScreenData", "getScreenSize"));
            }
            return screenSize;
        }
        double diagonalDp = 160.0 * diagonalSize;
        if (diagonalDp >= 1200.0) {
            ScreenSize screenSize = ScreenSize.XLARGE;
            if (screenSize == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdScreenData", "getScreenSize"));
            }
            return screenSize;
        }
        if (diagonalDp >= 800.0) {
            ScreenSize screenSize = ScreenSize.LARGE;
            if (screenSize == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdScreenData", "getScreenSize"));
            }
            return screenSize;
        }
        if (diagonalDp >= 568.0) {
            ScreenSize screenSize = ScreenSize.NORMAL;
            if (screenSize == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdScreenData", "getScreenSize"));
            }
            return screenSize;
        }
        ScreenSize screenSize = ScreenSize.SMALL;
        if (screenSize == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdScreenData", "getScreenSize"));
        }
        return screenSize;
    }

    @NotNull
    public static ScreenRatio getScreenRatio(int width, int height) {
        int shortSide;
        int longSide = Math.max(width, height);
        if ((double)longSide / (double)(shortSide = Math.min(width, height)) >= 1.6666666666666667) {
            ScreenRatio screenRatio = ScreenRatio.LONG;
            if (screenRatio == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdScreenData", "getScreenRatio"));
            }
            return screenRatio;
        }
        ScreenRatio screenRatio = ScreenRatio.NOTLONG;
        if (screenRatio == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdScreenData", "getScreenRatio"));
        }
        return screenRatio;
    }

    @NotNull
    public static Density getScreenDensity(double dpi) {
        double minDifference = Double.MAX_VALUE;
        Density bucket = Density.MEDIUM;
        for (Density d : Density.values()) {
            double difference;
            if (!d.isValidValueForDevice() || !((difference = Math.abs((double)d.getDpiValue() - dpi)) < minDifference)) continue;
            minDifference = Math.abs((double)d.getDpiValue() - dpi);
            bucket = d;
        }
        Density density = bucket;
        if (density == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdScreenData", "getScreenDensity"));
        }
        return density;
    }

    @NotNull
    public Screen createScreen() {
        Screen screen = new Screen();
        screen.setMultitouch(Multitouch.JAZZ_HANDS);
        screen.setMechanism(TouchScreen.FINGER);
        screen.setScreenType(ScreenType.CAPACITIVE);
        screen.setScreenRound((Boolean)this.myDeviceData.isScreenRound().get() != false ? ScreenRound.ROUND : ScreenRound.NOTROUND);
        screen.setDiagonalLength(((Double)this.myDeviceData.diagonalScreenSize().get()).doubleValue());
        screen.setSize(AvdScreenData.getScreenSize((Double)this.myDeviceData.diagonalScreenSize().get()));
        screen.setXDimension(((Integer)this.myDeviceData.screenResolutionWidth().get()).intValue());
        screen.setYDimension(((Integer)this.myDeviceData.screenResolutionHeight().get()).intValue());
        screen.setRatio(AvdScreenData.getScreenRatio((Integer)this.myDeviceData.screenResolutionWidth().get(), (Integer)this.myDeviceData.screenResolutionHeight().get()));
        Double dpi = (Double)this.myDeviceData.screenDpi().get();
        if (dpi <= 0.0) {
            dpi = AvdScreenData.calculateDpi(((Integer)this.myDeviceData.screenResolutionWidth().get()).intValue(), ((Integer)this.myDeviceData.screenResolutionHeight().get()).intValue(), (Double)this.myDeviceData.diagonalScreenSize().get());
        }
        dpi = (double)Math.round(dpi * 100.0) / 100.0;
        screen.setYdpi(dpi.doubleValue());
        screen.setXdpi(dpi.doubleValue());
        if (((Boolean)this.myDeviceData.isTv().get()).booleanValue()) {
            screen.setPixelDensity(Density.TV);
        } else {
            screen.setPixelDensity(AvdScreenData.getScreenDensity(dpi));
        }
        Screen screen2 = screen;
        if (screen2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdScreenData", "createScreen"));
        }
        return screen2;
    }
}

