/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.NightMode;
import com.android.resources.ScreenOrientation;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.rendering.RenderService;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class OrientationMenuAction
extends FlatComboAction {
    private final RenderContext myRenderContext;
    private final boolean myClassicStyle;

    public OrientationMenuAction(RenderContext renderContext) {
        this(renderContext, !RenderService.NELE_ENABLED);
    }

    public OrientationMenuAction(RenderContext renderContext, boolean classicStyle) {
        this.myRenderContext = renderContext;
        this.myClassicStyle = classicStyle;
        Presentation presentation = this.getTemplatePresentation();
        this.updatePresentation(presentation);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        State flip;
        State current;
        if (!this.myClassicStyle) {
            presentation.setIcon(AndroidIcons.NeleIcons.Rotate);
            return;
        }
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (current = configuration.getDeviceState()) != null && (flip = configuration.getNextDeviceState(current)) != null) {
            ScreenOrientation orientation = OrientationMenuAction.getOrientation(flip);
            presentation.setIcon(OrientationMenuAction.getOrientationIcon(orientation, true));
            presentation.setDescription(OrientationMenuAction.getPresentationDescription(flip));
        }
    }

    @NotNull
    private static String getPresentationDescription(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/configurations/OrientationMenuAction", "getPresentationDescription"));
        }
        String string = String.format("Switch to %1$s", state.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/OrientationMenuAction", "getPresentationDescription"));
        }
        return string;
    }

    @Override
    protected boolean handleIconClicked() {
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return false;
        }
        State current = configuration.getDeviceState();
        State flip = configuration.getNextDeviceState(current);
        if (flip != null) {
            SetDeviceStateAction action = new SetDeviceStateAction(this.myRenderContext, flip.getName(), flip, false, false);
            action.perform();
        }
        return true;
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null) {
            Device device = configuration.getDevice();
            if (device != null) {
                List states = device.getAllStates();
                State current = configuration.getDeviceState();
                if (states.size() > 1 && current != null) {
                    State flip = configuration.getNextDeviceState(current);
                    State nextSate = flip == null ? current : flip;
                    String title = OrientationMenuAction.getPresentationDescription(nextSate);
                    group.add((AnAction)new SetDeviceStateAction(this.myRenderContext, title, nextSate, false, true));
                    group.addSeparator();
                }
                for (State config : states) {
                    String stateName;
                    String title = stateName = config.getName();
                    VirtualFile better = ConfigurationMatcher.getBetterMatch(configuration, null, stateName, null, null);
                    if (better != null) {
                        title = ConfigurationAction.getBetterMatchLabel(stateName, better, configuration.getFile());
                    }
                    group.add((AnAction)new SetDeviceStateAction(this.myRenderContext, title, config, config == current, false));
                }
                group.addSeparator();
            }
            group.addSeparator();
            DefaultActionGroup uiModeGroup = new DefaultActionGroup("_UI Mode", true);
            UiMode currentUiMode = configuration.getUiMode();
            for (State uiMode : UiMode.values()) {
                String title = uiMode.getShortDisplayValue();
                boolean checked = uiMode == currentUiMode;
                uiModeGroup.add((AnAction)new SetUiModeAction(this.myRenderContext, title, (UiMode)uiMode, checked));
            }
            group.add((AnAction)uiModeGroup);
            group.addSeparator();
            DefaultActionGroup nightModeGroup = new DefaultActionGroup("_Night Mode", true);
            NightMode currentNightMode = configuration.getNightMode();
            for (NightMode nightMode : NightMode.values()) {
                String title = nightMode.getShortDisplayValue();
                boolean checked = nightMode == currentNightMode;
                nightModeGroup.add((AnAction)new SetNightModeAction(this.myRenderContext, title, nightMode, checked));
            }
            group.add((AnAction)nightModeGroup);
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/OrientationMenuAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    public static Icon getOrientationIcon(@NotNull ScreenOrientation orientation, boolean flip) {
        if (orientation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orientation", "com/android/tools/idea/configurations/OrientationMenuAction", "getOrientationIcon"));
        }
        switch (orientation) {
            case LANDSCAPE: {
                Icon icon = flip ? AndroidIcons.FlipLandscape : AndroidIcons.Landscape;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/OrientationMenuAction", "getOrientationIcon"));
                }
                return icon;
            }
            case SQUARE: {
                Icon icon = AndroidIcons.Square;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/OrientationMenuAction", "getOrientationIcon"));
                }
                return icon;
            }
        }
        Icon icon = flip ? AndroidIcons.FlipPortrait : AndroidIcons.Portrait;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/OrientationMenuAction", "getOrientationIcon"));
        }
        return icon;
    }

    @NotNull
    public static ScreenOrientation getOrientation(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/configurations/OrientationMenuAction", "getOrientation"));
        }
        FolderConfiguration config = DeviceConfigHelper.getFolderConfig((State)state);
        ScreenOrientation orientation = null;
        if (config != null && config.getScreenOrientationQualifier() != null) {
            orientation = config.getScreenOrientationQualifier().getValue();
        }
        if (orientation == null) {
            orientation = ScreenOrientation.PORTRAIT;
        }
        ScreenOrientation screenOrientation = orientation;
        if (screenOrientation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/OrientationMenuAction", "getOrientation"));
        }
        return screenOrientation;
    }

    private static class SetNightModeAction
    extends ConfigurationAction {
        @NotNull
        private final NightMode myNightMode;

        private SetNightModeAction(@NotNull RenderContext renderContext, @NotNull String title, @NotNull NightMode nightMode, boolean checked) {
            if (renderContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/android/tools/idea/configurations/OrientationMenuAction$SetNightModeAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/configurations/OrientationMenuAction$SetNightModeAction", "<init>"));
            }
            if (nightMode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nightMode", "com/android/tools/idea/configurations/OrientationMenuAction$SetNightModeAction", "<init>"));
            }
            super(renderContext, title);
            this.myNightMode = nightMode;
            if (checked) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/configurations/OrientationMenuAction$SetNightModeAction", "updateConfiguration"));
            }
            configuration.setNightMode(this.myNightMode);
        }
    }

    private static class SetUiModeAction
    extends ConfigurationAction {
        @NotNull
        private final UiMode myUiMode;

        private SetUiModeAction(@NotNull RenderContext renderContext, @NotNull String title, @NotNull UiMode uiMode, boolean checked) {
            if (renderContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/android/tools/idea/configurations/OrientationMenuAction$SetUiModeAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/configurations/OrientationMenuAction$SetUiModeAction", "<init>"));
            }
            if (uiMode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiMode", "com/android/tools/idea/configurations/OrientationMenuAction$SetUiModeAction", "<init>"));
            }
            super(renderContext, title);
            this.myUiMode = uiMode;
            if (checked) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/configurations/OrientationMenuAction$SetUiModeAction", "updateConfiguration"));
            }
            configuration.setUiMode(this.myUiMode);
        }
    }

    private static class SetDeviceStateAction
    extends ConfigurationAction {
        @NotNull
        private final State myState;

        private SetDeviceStateAction(@NotNull RenderContext renderContext, @NotNull String title, @NotNull State state, boolean checked, boolean flip) {
            if (renderContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/android/tools/idea/configurations/OrientationMenuAction$SetDeviceStateAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/configurations/OrientationMenuAction$SetDeviceStateAction", "<init>"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/configurations/OrientationMenuAction$SetDeviceStateAction", "<init>"));
            }
            super(renderContext, title);
            this.myState = state;
            ScreenOrientation orientation = OrientationMenuAction.getOrientation(state);
            this.getTemplatePresentation().setIcon(OrientationMenuAction.getOrientationIcon(orientation, flip));
        }

        public void perform() {
            this.tryUpdateConfiguration();
            this.updatePresentation();
            this.myRenderContext.requestRender();
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/configurations/OrientationMenuAction$SetDeviceStateAction", "updateConfiguration"));
            }
            configuration.setDeviceState(this.myState);
        }
    }
}

