/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.widgets;

import com.android.tools.idea.editors.gfxtrace.renderers.RenderUtils;
import com.android.tools.idea.editors.gfxtrace.widgets.Repaintable;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.util.ConcurrencyUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;

public class LoadingIndicator {
    private static final Icon[] LOADING_ICONS = new Icon[]{AllIcons.Process.Big.Step_1, AllIcons.Process.Big.Step_2, AllIcons.Process.Big.Step_3, AllIcons.Process.Big.Step_4, AllIcons.Process.Big.Step_5, AllIcons.Process.Big.Step_6, AllIcons.Process.Big.Step_7, AllIcons.Process.Big.Step_8, AllIcons.Process.Big.Step_9, AllIcons.Process.Big.Step_10, AllIcons.Process.Big.Step_11, AllIcons.Process.Big.Step_12};
    private static final long MS_PER_FRAME = 60L;
    private static final long CYCLE_LENGTH = (long)LOADING_ICONS.length * 60L;
    private static final int MIN_SIZE = 3 * LOADING_ICONS[0].getIconWidth() / 2;
    private static final Set<Repaintable> componentsToRedraw = Sets.newIdentityHashSet();
    private static final ScheduledExecutorService tickerScheduler = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"LoadingAnimation");

    public static void paint(Component c, Graphics g, int x, int y, int w, int h) {
        long elapsed = System.currentTimeMillis() % CYCLE_LENGTH;
        if (Math.min(w, h) < MIN_SIZE) {
            Graphics2D child = (Graphics2D)g.create(x, y, w, h);
            child.scale(0.5, 0.5);
            RenderUtils.drawIcon(c, child, LOADING_ICONS[(int)(elapsed * (long)LOADING_ICONS.length / CYCLE_LENGTH)], 0, 0, w * 2, h * 2);
            child.dispose();
        } else {
            RenderUtils.drawIcon(c, g, LOADING_ICONS[(int)(elapsed * (long)LOADING_ICONS.length / CYCLE_LENGTH)], x, y, w, h);
        }
    }

    public static Dimension getMinimumSize() {
        return new Dimension(LOADING_ICONS[0].getIconWidth(), LOADING_ICONS[0].getIconHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleForRedraw(Repaintable c) {
        Set<Repaintable> set = componentsToRedraw;
        synchronized (set) {
            if (componentsToRedraw.add(c) && componentsToRedraw.size() == 1) {
                tickerScheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        LoadingIndicator.redrawAll();
                    }
                }, 60L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void redrawAll() {
        Repaintable[] repaintableArray = componentsToRedraw;
        synchronized (componentsToRedraw) {
            Repaintable[] components = componentsToRedraw.toArray(new Repaintable[componentsToRedraw.size()]);
            componentsToRedraw.clear();
            // ** MonitorExit[var1] (shouldn't be in output)
            for (Repaintable c : components) {
                c.repaint();
            }
            return;
        }
    }
}

