/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.widgets;

import com.intellij.ui.components.JBTextField;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextField
extends JBTextField {
    private final ChangeEvent myChangeEvent = new ChangeEvent((Object)this);
    private final AtomicBoolean fireEvents = new AtomicBoolean(true);

    public TextField() {
        this.init();
    }

    public TextField(int columns) {
        super(columns);
        this.init();
    }

    public TextField(String text) {
        super(text);
        this.init();
    }

    public TextField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    private void init() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextField.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextField.this.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextField.this.fireChange();
            }
        });
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text, boolean fireEvent) {
        boolean currentValue = this.fireEvents.getAndSet(fireEvent);
        try {
            super.setText(text);
        }
        finally {
            this.fireEvents.set(currentValue);
        }
    }

    protected void fireChange() {
        if (this.fireEvents.get()) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                ((ChangeListener)listeners[i + 1]).stateChanged(this.myChangeEvent);
            }
        }
    }

    public void addChangedListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }
}

