/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.descriptors;

import com.android.tools.idea.editors.hprof.jdi.FieldImpl;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.Field;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.Value;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HprofFieldDescriptorImpl
extends FieldDescriptorImpl {
    @NotNull
    protected Field myField;
    @Nullable
    protected Object myValueData;
    protected int myMemoryOrdering;

    public HprofFieldDescriptorImpl(@NotNull Project project, @NotNull Field field, @Nullable Object value, int memoryOrdering) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/hprof/descriptors/HprofFieldDescriptorImpl", "<init>"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/android/tools/idea/editors/hprof/descriptors/HprofFieldDescriptorImpl", "<init>"));
        }
        super(project, null, (com.sun.jdi.Field)new FieldImpl(field, value));
        this.myField = field;
        this.myValueData = value;
        this.myMemoryOrdering = memoryOrdering;
    }

    public static void batchUpdateRepresentation(final @NotNull List<HprofFieldDescriptorImpl> descriptors, @NotNull DebuggerManagerThreadImpl debuggerManagerThread, final @NotNull SuspendContextImpl suspendContext) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/android/tools/idea/editors/hprof/descriptors/HprofFieldDescriptorImpl", "batchUpdateRepresentation"));
        }
        if (debuggerManagerThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerManagerThread", "com/android/tools/idea/editors/hprof/descriptors/HprofFieldDescriptorImpl", "batchUpdateRepresentation"));
        }
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/android/tools/idea/editors/hprof/descriptors/HprofFieldDescriptorImpl", "batchUpdateRepresentation"));
        }
        debuggerManagerThread.invokeAndWait(new DebuggerCommandImpl(){

            protected void action() throws Exception {
                for (HprofFieldDescriptorImpl descriptor : descriptors) {
                    descriptor.updateRepresentation(new EvaluationContextImpl(suspendContext, null, descriptor.getValue()), new DescriptorLabelListener(){

                        public void labelChanged() {
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public Object getValueData() {
        return this.myValueData;
    }

    public abstract Value calcValue(EvaluationContextImpl var1);

    public abstract Value getValue();

    public PsiExpression getDescriptorEvaluation(DebuggerContext context) {
        return null;
    }

    @NotNull
    public Field getHprofField() {
        Field field = this.myField;
        if (field == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/hprof/descriptors/HprofFieldDescriptorImpl", "getHprofField"));
        }
        return field;
    }

    public boolean isArray() {
        return this.myValueData instanceof ArrayInstance;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isLvalue() {
        return false;
    }

    public boolean isNull() {
        return this.myValueData == null;
    }

    public int getMemoryOrdering() {
        return this.myMemoryOrdering;
    }
}

