/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.model;

import com.intellij.openapi.util.text.StringUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;

public class Utilities {
    public static final String NAME_SPACE_ATRIBUTE_NAME = "ns";
    public static final String ID_ATTRIBUTE_NAME = "id";
    public static final String IDREF_ATTRIBUTE_NAME = "idref";
    public static final String PROPERTY_ATTRIBUTE_NAME = "outer.property";
    public static final Set<String> RESERVED_ATTRIBUTES = new HashSet<String>(Arrays.asList("ns", "id", "idref", "outer.property"));

    public static Map<String, String> toMap(Attributes attributes) {
        LinkedHashMap<String, String> nameToValue = new LinkedHashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            nameToValue.put(attributes.getQName(i), attributes.getValue(i));
        }
        return nameToValue;
    }

    public static String getGetterMethodName(String propertyName) {
        return "get" + StringUtil.capitalize((String)propertyName);
    }

    public static String getPropertyName(Method getter) {
        return Utilities.getPropertyName(getter.getName());
    }

    public static String getPropertyName(String getterName) {
        assert (getterName.startsWith("get"));
        return Utilities.decapitalize(getterName.substring(3));
    }

    public static String getSetterMethodName(String propertyName) {
        return "set" + StringUtil.capitalize((String)propertyName);
    }

    public static String decapitalize(String propertyName) {
        return Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    static Class wrapperForPrimitiveType(Class type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        throw new RuntimeException("Internal error");
    }
}

