/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectStructureAction
extends AndroidStudioGradleAction {
    public AbstractProjectStructureAction(@Nullable String text) {
        super(text);
    }

    protected AbstractProjectStructureAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/AbstractProjectStructureAction", "doUpdate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/AbstractProjectStructureAction", "doUpdate"));
        }
        e.getPresentation().setEnabled(this.getTargetModule(e) != null);
    }

    @Override
    protected final void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        ProjectSettingsService service;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/AbstractProjectStructureAction", "doPerform"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/AbstractProjectStructureAction", "doPerform"));
        }
        Module module = this.getTargetModule(e);
        if (module != null && (service = ProjectSettingsService.getInstance((Project)module.getProject())) instanceof AndroidProjectSettingsService) {
            this.doPerform(module, (AndroidProjectSettingsService)service, e);
        }
    }

    protected abstract Module getTargetModule(@NotNull AnActionEvent var1);

    @Nullable
    protected static Module getSelectedAndroidModule(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/AbstractProjectStructureAction", "getSelectedAndroidModule"));
        }
        Module module = AbstractProjectStructureAction.getSelectedGradleModule(e);
        if (module != null && AndroidFacet.getInstance(module) != null) {
            return module;
        }
        return null;
    }

    @Nullable
    protected static Module getSelectedGradleModule(@NotNull AnActionEvent e) {
        ProjectFileIndex fileIndex;
        VirtualFile file;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/AbstractProjectStructureAction", "getSelectedGradleModule"));
        }
        DataContext dataContext = e.getDataContext();
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (AbstractProjectStructureAction.isGradleModule(module)) {
            return module;
        }
        Project project = e.getProject();
        if (project != null && (file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null && AbstractProjectStructureAction.isGradleModule(module = (fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project)).getModuleForFile(file))) {
            return module;
        }
        return null;
    }

    private static boolean isGradleModule(@Nullable Module module) {
        return module != null && Projects.isBuildWithGradle(module);
    }

    protected abstract void doPerform(@NotNull Module var1, @NotNull AndroidProjectSettingsService var2, @NotNull AnActionEvent var3);
}

