/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer;

import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.util.FilePaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCompileOutputModuleCustomizer<T>
implements ModuleCustomizer<T> {
    private static final Logger LOG = Logger.getInstance(AbstractCompileOutputModuleCustomizer.class);

    protected void setOutputPaths(@NotNull ModifiableRootModel ideaModuleModel, @NotNull File mainDirPath, @Nullable File testDirPath) {
        if (ideaModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModuleModel", "com/android/tools/idea/gradle/customizer/AbstractCompileOutputModuleCustomizer", "setOutputPaths"));
        }
        if (mainDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainDirPath", "com/android/tools/idea/gradle/customizer/AbstractCompileOutputModuleCustomizer", "setOutputPaths"));
        }
        CompilerModuleExtension compilerSettings = (CompilerModuleExtension)ideaModuleModel.getModuleExtension(CompilerModuleExtension.class);
        if (compilerSettings == null) {
            LOG.warn(String.format("No compiler extension is found for module '%1$s'", ideaModuleModel.getModule().getName()));
            return;
        }
        compilerSettings.inheritCompilerOutputPath(false);
        compilerSettings.setCompilerOutputPath(FilePaths.pathToIdeaUrl(mainDirPath));
        if (testDirPath != null) {
            compilerSettings.setCompilerOutputPathForTests(FilePaths.pathToIdeaUrl(testDirPath));
        }
    }
}

