/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeDependencyModel
extends DependencyModel {
    private static final Logger LOG = Logger.getInstance(FileTreeDependencyModel.class);
    @NonNls
    private static final String FILE_TREE = "fileTree";
    @NonNls
    private static final String DIR = "dir";
    @NonNls
    private static final String INCLUDE = "include";
    @NonNls
    private static final String EXCLUDE = "exclude";
    @NotNull
    private final GradleDslMethodCall myDslElement;
    @NotNull
    private final GradleDslExpression myDir;
    @Nullable
    private final GradleDslElement myIncludeElement;
    @Nullable
    private final GradleDslElement myExcludeElement;

    public FileTreeDependencyModel(@NotNull GradleDslMethodCall dslElement, @NotNull GradleDslExpression dir, @Nullable GradleDslElement includeElement, @Nullable GradleDslElement excludeElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel", "<init>"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", DIR, "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel", "<init>"));
        }
        this.myDslElement = dslElement;
        this.myDir = dir;
        this.myIncludeElement = includeElement;
        this.myExcludeElement = excludeElement;
    }

    @Override
    @NotNull
    protected GradleDslElement getDslElement() {
        GradleDslMethodCall gradleDslMethodCall = this.myDslElement;
        if (gradleDslMethodCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel", "getDslElement"));
        }
        return gradleDslMethodCall;
    }

    @NotNull
    public String dir() {
        String dir = this.myDir.getValue(String.class);
        assert (dir != null);
        String string = dir;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel", DIR));
        }
        return string;
    }

    public void setDir(@NotNull String dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", DIR, "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel", "setDir"));
        }
        this.myDir.setValue(dir);
    }

    @NotNull
    public List<String> include() {
        List<String> list = FileTreeDependencyModel.getStringValues(this.myIncludeElement);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel", INCLUDE));
        }
        return list;
    }

    @NotNull
    public List<String> exclude() {
        List<String> list = FileTreeDependencyModel.getStringValues(this.myExcludeElement);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel", EXCLUDE));
        }
        return list;
    }

    @NotNull
    private static List<String> getStringValues(@Nullable GradleDslElement expressionOrList) {
        String value;
        if (expressionOrList instanceof GradleDslExpressionList) {
            List<String> list = ((GradleDslExpressionList)expressionOrList).getValues(String.class);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel", "getStringValues"));
            }
            return list;
        }
        if (expressionOrList instanceof GradleDslExpression && (value = ((GradleDslExpression)expressionOrList).getValue(String.class)) != null) {
            List<String> list = Collections.singletonList(value);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel", "getStringValues"));
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel", "getStringValues"));
        }
        return list;
    }

    public static Collection<? extends FileTreeDependencyModel> create(@NotNull GradleDslMethodCall methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/model/dependencies/FileTreeDependencyModel", "create"));
        }
        ArrayList result = Lists.newArrayList();
        if (FILE_TREE.equals(methodCall.getName())) {
            List<GradleDslElement> arguments = methodCall.getArguments();
            for (GradleDslElement argument : arguments) {
                if (argument instanceof GradleDslExpression) {
                    result.add(new FileTreeDependencyModel(methodCall, (GradleDslExpression)argument, null, null));
                    continue;
                }
                if (!(argument instanceof GradleDslExpressionMap)) continue;
                GradleDslExpressionMap dslMap = (GradleDslExpressionMap)argument;
                GradleDslExpression dirElement = dslMap.getProperty(DIR, GradleDslExpression.class);
                if (dirElement == null) {
                    assert (methodCall.getPsiElement() != null);
                    String msg = String.format("'%1$s' is not a valid file tree dependency", methodCall.getPsiElement().getText());
                    LOG.warn(msg);
                    continue;
                }
                GradleDslElement includeElement = dslMap.getPropertyElement(INCLUDE);
                GradleDslElement excludeElement = dslMap.getPropertyElement(EXCLUDE);
                result.add(new FileTreeDependencyModel(methodCall, dirElement, includeElement, excludeElement));
            }
        }
        return result;
    }
}

