/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.model.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public abstract class GradleDslExpression
extends GradleDslElement {
    @Nullable
    protected GrExpression myExpression;

    protected GradleDslExpression(@Nullable GradleDslElement parent, @Nullable GroovyPsiElement psiElement, @NotNull String name, @Nullable GrExpression expression) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "<init>"));
        }
        super(parent, psiElement, name);
        this.myExpression = expression;
    }

    @Nullable
    public GrExpression getExpression() {
        return this.myExpression;
    }

    @Nullable
    public abstract Object getValue();

    @Nullable
    public abstract <T> T getValue(@NotNull Class<T> var1);

    public abstract void setValue(@NotNull Object var1);

    @Nullable
    protected <T> T resolveReference(@NotNull String referenceText, @NotNull Class<T> clazz) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "resolveReference"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "resolveReference"));
        }
        GradleDslFile dslFile = this.getDslFile();
        if (dslFile != null && referenceText.contains(".")) {
            int firstDotIndex = referenceText.indexOf(".");
            String firstSegment = referenceText.substring(0, firstDotIndex).trim();
            String remainingReferenceText = referenceText.substring(firstDotIndex + 1);
            if ("project".equals(firstSegment)) {
                return this.resolveReference(dslFile, remainingReferenceText, clazz);
            }
            if ("parent".equals(firstSegment)) {
                GradleDslFile parentDslFile = dslFile.getParentModuleDslFile();
                if (parentDslFile != null) {
                    return this.resolveReference(parentDslFile, remainingReferenceText, clazz);
                }
                return null;
            }
            if ("rootProject".equals(firstSegment)) {
                while (dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir()))) {
                    dslFile = dslFile.getParentModuleDslFile();
                }
                if (dslFile != null) {
                    return this.resolveReference(dslFile, remainingReferenceText, clazz);
                }
                return null;
            }
            String standardProjectKey = ProjectPropertiesDslElement.getStandardProjectKey(firstSegment);
            if (standardProjectKey != null) {
                String modulePath = standardProjectKey.substring(standardProjectKey.indexOf("'") + 1, standardProjectKey.lastIndexOf("'"));
                GradleSettingsModel model = GradleSettingsModel.get(dslFile.getProject());
                if (model == null) {
                    return null;
                }
                File moduleDirectory = model.moduleDirectory(modulePath);
                if (moduleDirectory == null) {
                    return null;
                }
                while (dslFile != null && !FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)VfsUtilCore.virtualToIoFile((VirtualFile)dslFile.getProject().getBaseDir()))) {
                    dslFile = dslFile.getParentModuleDslFile();
                }
                if (dslFile == null) {
                    return null;
                }
                GradleDslFile moduleDslFile = GradleDslExpression.findDslFile(dslFile, moduleDirectory);
                if (moduleDslFile == null) {
                    return null;
                }
                return this.resolveReference(moduleDslFile, remainingReferenceText, clazz);
            }
        }
        return this.resolveReference(this, referenceText, clazz);
    }

    @Nullable
    protected <T> T resolveReference(GradleDslElement startElement, @NotNull String referenceText, @NotNull Class<T> clazz) {
        T extPropertyValue;
        ExtDslElement extDslElement;
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "resolveReference"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslExpression", "resolveReference"));
        }
        GradleDslFile dslFile = null;
        for (GradleDslElement element = startElement; dslFile == null && element != null; element = element.getParent()) {
            if (!(element instanceof GradlePropertiesDslElement)) continue;
            T propertyValue = ((GradlePropertiesDslElement)element).getProperty(referenceText, clazz);
            if (propertyValue != null) {
                return propertyValue;
            }
            if (!(element instanceof GradleDslFile) || (extDslElement = (dslFile = (GradleDslFile)element).getProperty("ext", ExtDslElement.class)) == null || (extPropertyValue = extDslElement.getProperty(referenceText, clazz)) == null) continue;
            return extPropertyValue;
        }
        GradleDslFile parentDslFile = null;
        if (dslFile != null) {
            parentDslFile = dslFile.getParentModuleDslFile();
        }
        while (parentDslFile != null) {
            extDslElement = parentDslFile.getProperty("ext", ExtDslElement.class);
            if (extDslElement != null && (extPropertyValue = extDslElement.getProperty(referenceText, clazz)) != null) {
                return extPropertyValue;
            }
            parentDslFile = parentDslFile.getParentModuleDslFile();
        }
        if (clazz.isAssignableFrom(String.class)) {
            if (dslFile != null && "rootDir".equals(referenceText)) {
                return clazz.cast(Projects.getBaseDirPath(dslFile.getProject()).getPath());
            }
            if (dslFile != null && "projectDir".equals(referenceText)) {
                return clazz.cast(dslFile.getDirectoryPath().getPath());
            }
            return clazz.cast(referenceText);
        }
        return null;
    }

    @Nullable
    private GradleDslFile getDslFile() {
        for (GradleDslElement element = this; element != null; element = element.getParent()) {
            if (!(element instanceof GradleDslFile)) continue;
            return (GradleDslFile)element;
        }
        return null;
    }

    @Nullable
    private static GradleDslFile findDslFile(GradleDslFile rootModuleDslFile, File moduleDirectory) {
        if (FileUtil.filesEqual((File)rootModuleDslFile.getDirectoryPath(), (File)moduleDirectory)) {
            return rootModuleDslFile;
        }
        for (GradleDslFile dslFile : rootModuleDslFile.getChildModuleDslFiles()) {
            if (FileUtil.filesEqual((File)dslFile.getDirectoryPath(), (File)moduleDirectory)) {
                return dslFile;
            }
            GradleDslFile childDslFile = GradleDslExpression.findDslFile(dslFile, moduleDirectory);
            if (childDslFile == null) continue;
            return dslFile;
        }
        return null;
    }
}

