/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public abstract class NewProjectImportGradleSyncListener
extends GradleSyncListener.Adapter {
    @Override
    public void syncFailed(final @NotNull Project project, @NotNull String errorMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/NewProjectImportGradleSyncListener", "syncFailed"));
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/project/NewProjectImportGradleSyncListener", "syncFailed"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                NewProjectImportGradleSyncListener.createTopLevelProjectAndOpen(project);
            }
        });
    }

    public static void createTopLevelProjectAndOpen(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/NewProjectImportGradleSyncListener", "createTopLevelProjectAndOpen"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                NewProjectImportGradleSyncListener.createTopLevelModule(project);
            }
        });
        Projects.open(project);
        NewProjectImportGradleSyncListener.activateProjectView(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTopLevelModule(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/NewProjectImportGradleSyncListener", "createTopLevelModule"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        File projectRootDir = Projects.getBaseDirPath(project);
        VirtualFile contentRoot = VfsUtil.findFileByIoFile((File)projectRootDir, (boolean)true);
        if (contentRoot != null) {
            Sdk jdk;
            File moduleFile = new File(projectRootDir, projectRootDir.getName() + ".iml");
            Module module = moduleManager.newModule(moduleFile.getPath(), StdModuleTypes.JAVA.getId());
            module.setOption("external.system.id", GradleUtil.GRADLE_SYSTEM_ID.getId());
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            model.addContentEntry(contentRoot);
            if (AndroidStudioInitializer.isAndroidStudio() && (jdk = IdeSdks.getJdk()) != null) {
                model.setSdk(jdk);
            }
            model.commit();
            FacetManager facetManager = FacetManager.getInstance((Module)module);
            ModifiableFacetModel facetModel = facetManager.createModifiableModel();
            try {
                AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
                if (gradleFacet == null) {
                    gradleFacet = (AndroidGradleFacet)facetManager.createFacet((FacetType)AndroidGradleFacet.getFacetType(), "Android-Gradle", null);
                    facetModel.addFacet((Facet)gradleFacet);
                }
                ((AndroidGradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH = ":";
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null) {
                    androidFacet = (AndroidFacet)facetManager.createFacet((FacetType)AndroidFacet.getFacetType(), "Android", null);
                    facetModel.addFacet((Facet)androidFacet);
                }
                androidFacet.getProperties().ALLOW_USER_CONFIGURATION = false;
            }
            finally {
                facetModel.commit();
            }
        }
    }

    public static void activateProjectView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/NewProjectImportGradleSyncListener", "activateProjectView"));
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.PROJECT_VIEW);
        if (window != null) {
            window.activate(null, false);
        }
    }

    @Override
    public void syncSkipped(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/NewProjectImportGradleSyncListener", "syncSkipped"));
        }
    }
}

