/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.testing;

import com.android.tools.idea.gradle.testing.TestArtifactSearchScopes;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.Colored;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestArtifactCustomScopeProvider
extends CustomScopesProviderEx {
    private static List<NamedScope> SCOPES = ImmutableList.of((Object)((Object)new UnitTestsScope()), (Object)((Object)new AndroidTestsScope()));

    @NotNull
    public List<NamedScope> getCustomScopes() {
        List<NamedScope> list = SCOPES;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/testing/TestArtifactCustomScopeProvider", "getCustomScopes"));
        }
        return list;
    }

    public boolean isVetoed(@NotNull NamedScope scope, @NotNull CustomScopesProviderEx.ScopePlace place) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/testing/TestArtifactCustomScopeProvider", "isVetoed"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/gradle/testing/TestArtifactCustomScopeProvider", "isVetoed"));
        }
        return scope instanceof AndroidTestsScope && place == CustomScopesProviderEx.ScopePlace.ACTION;
    }

    @Colored(color="e7fadb", darkVariant="2A3B2C")
    public static class UnitTestsScope
    extends NamedScope {
        public static final String NAME = IdeBundle.message((String)"predefined.scope.tests.name", (Object[])new Object[0]);

        public UnitTestsScope() {
            super(NAME, (PackageSet)new AbstractPackageSet("test:*..*"){

                public boolean contains(@Nullable VirtualFile file, @NotNull NamedScopesHolder holder) {
                    if (holder == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/android/tools/idea/gradle/testing/TestArtifactCustomScopeProvider$UnitTestsScope$1", "contains"));
                    }
                    return this.contains(file, holder.getProject(), holder);
                }

                public boolean contains(@Nullable VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/testing/TestArtifactCustomScopeProvider$UnitTestsScope$1", "contains"));
                    }
                    if (file == null) {
                        return false;
                    }
                    Module module = FileIndexFacade.getInstance((Project)project).getModuleForFile(file);
                    if (module == null) {
                        return false;
                    }
                    TestArtifactSearchScopes scopes = TestArtifactSearchScopes.get(module);
                    if (scopes == null) {
                        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(file);
                    }
                    return scopes.isUnitTestSource(file);
                }
            });
        }
    }

    @Colored(color="ffffe4", darkVariant="494539")
    public static class AndroidTestsScope
    extends NamedScope {
        public static final String NAME = "Android Instrumentation Tests";

        public AndroidTestsScope() {
            super(NAME, (PackageSet)new AbstractPackageSet("test:*..*"){

                public boolean contains(@Nullable VirtualFile file, @NotNull NamedScopesHolder holder) {
                    if (holder == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/android/tools/idea/gradle/testing/TestArtifactCustomScopeProvider$AndroidTestsScope$1", "contains"));
                    }
                    return this.contains(file, holder.getProject(), holder);
                }

                public boolean contains(@Nullable VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/testing/TestArtifactCustomScopeProvider$AndroidTestsScope$1", "contains"));
                    }
                    if (file == null) {
                        return false;
                    }
                    Module module = FileIndexFacade.getInstance((Project)project).getModuleForFile(file);
                    if (module == null) {
                        return false;
                    }
                    TestArtifactSearchScopes scopes = TestArtifactSearchScopes.get(module);
                    if (scopes == null) {
                        return false;
                    }
                    return scopes.isAndroidTestSource(file);
                }
            });
        }
    }
}

