/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class EmbeddedDistributionPaths {
    private static final Logger LOG = Logger.getInstance(EmbeddedDistributionPaths.class);

    @Nullable
    public static File findAndroidStudioLocalMavenRepoPath() {
        File repoPath;
        File defaultRootDirPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (defaultRootDirPath != null) {
            repoPath = new File(defaultRootDirPath, "m2repository");
        } else {
            String studioCustomRepo = System.getenv("STUDIO_CUSTOM_REPO");
            if (studioCustomRepo != null) {
                repoPath = new File(FileUtil.toCanonicalPath((String)FileUtil.toSystemDependentName((String)studioCustomRepo)));
                if (!repoPath.isDirectory()) {
                    throw new IllegalArgumentException("Invalid path in STUDIO_CUSTOM_REPO environment variable");
                }
            } else {
                String relativePath = FileUtil.toSystemDependentName((String)"/../../prebuilts/tools/common/offline-m2");
                repoPath = new File(FileUtil.toCanonicalPath((String)(FileUtil.toSystemDependentName((String)PathManager.getHomePath()) + relativePath)));
            }
        }
        LOG.info("Looking for embedded Maven repo at '" + repoPath.getPath() + "'");
        return repoPath.isDirectory() ? repoPath : null;
    }

    @Nullable
    public static File findEmbeddedGradleDistributionPath() {
        File defaultRootDirPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (defaultRootDirPath != null) {
            File embeddedPath = new File(defaultRootDirPath, "gradle-2.10");
            LOG.info("Looking for embedded Gradle distribution at '" + embeddedPath.getPath() + "'");
            if (embeddedPath.isDirectory()) {
                LOG.info("Found embedded Gradle 2.10");
                return embeddedPath;
            }
            LOG.info("Unable to find embedded Gradle 2.10");
            return null;
        }
        return null;
    }

    @Nullable
    private static File getDefaultRootDirPath() {
        String ideHomePath = FileUtil.toSystemDependentName((String)PathManager.getHomePath());
        File rootDirPath = new File(ideHomePath, "gradle");
        return rootDirPath.isDirectory() ? rootDirPath : null;
    }
}

