/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.actions;

import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.stats.UsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import org.jetbrains.annotations.NotNull;

public class RecordingAction
extends ToggleAction {
    @NotNull
    private final BaseMonitorView myMonitorView;

    public RecordingAction(@NotNull BaseMonitorView monitorView) {
        if (monitorView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "monitorView", "com/android/tools/idea/monitor/actions/RecordingAction", "<init>"));
        }
        super(null, null, AllIcons.Actions.Pause);
        this.myMonitorView = monitorView;
    }

    public boolean isSelected(AnActionEvent e) {
        return this.myMonitorView.getIsPaused();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/monitor/actions/RecordingAction", "update"));
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (this.isSelected(e)) {
            presentation.setText("Disabled");
            presentation.setDescription("Click to enable " + this.myMonitorView.getDescription() + " recording.");
        } else {
            presentation.setText("Enabled");
            presentation.setDescription("Click to disable " + this.myMonitorView.getDescription() + " recording.");
        }
    }

    public void setSelected(AnActionEvent e, boolean state) {
        if (this.myMonitorView.getIsPaused() != state) {
            UsageTracker.getInstance().trackEvent("profiling", "runningMonitor", this.myMonitorView.getDescription(), state ? 0 : 1);
        }
        this.myMonitorView.setIsPaused(state);
    }
}

