/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.gradle.project.NewProjectImportGradleSyncListener;
import com.android.tools.idea.templates.TemplateUtils;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

final class ReformattingGradleSyncListener
extends NewProjectImportGradleSyncListener {
    @NotNull
    private final Collection<File> myTargetFiles;
    @NotNull
    private final Collection<File> myFilesToOpen;

    ReformattingGradleSyncListener(@NotNull Collection<File> targetFiles, @NotNull Collection<File> filesToOpen) {
        if (targetFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFiles", "com/android/tools/idea/npw/ReformattingGradleSyncListener", "<init>"));
        }
        if (filesToOpen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToOpen", "com/android/tools/idea/npw/ReformattingGradleSyncListener", "<init>"));
        }
        this.myTargetFiles = targetFiles;
        this.myFilesToOpen = filesToOpen;
    }

    @Override
    public void syncSucceeded(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/ReformattingGradleSyncListener", "syncSucceeded"));
        }
        StartupManagerEx manager = StartupManagerEx.getInstanceEx((Project)project);
        if (manager.postStartupActivityPassed()) {
            this.reformatRearrangeAndOpen(project);
        } else {
            manager.registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    ReformattingGradleSyncListener.this.reformatRearrangeAndOpen(project);
                }
            });
        }
    }

    private void reformatRearrangeAndOpen(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/npw/ReformattingGradleSyncListener", "reformatRearrangeAndOpen"));
        }
        TemplateUtils.reformatAndRearrange(project, this.myTargetFiles);
        TemplateUtils.openEditors(project, this.myFilesToOpen, true);
    }
}

