/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.configurations.OverlayContainer;
import com.android.tools.idea.rendering.Overlay;
import com.android.tools.idea.rendering.RenderedView;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.intellij.android.designer.designSurface.graphics.DesignerGraphics;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoverOverlay
extends Overlay {
    private final OverlayContainer myContainer;
    private RenderedView myHoveredView;

    public HoverOverlay(@NotNull OverlayContainer container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/android/tools/idea/rendering/HoverOverlay", "<init>"));
        }
        this.myContainer = container;
    }

    public boolean setHoveredView(@Nullable RenderedView view) {
        boolean changed;
        boolean bl = changed = view != this.myHoveredView;
        if (changed) {
            this.myHoveredView = view;
        }
        return changed;
    }

    @Override
    public void paint(@Nullable Component component, @NotNull Graphics2D gc, int deltaX, int deltaY) {
        if (gc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/rendering/HoverOverlay", "paint"));
        }
        if (component == null || this.myHoveredView == null) {
            return;
        }
        RenderedViewHierarchy viewHierarchy = this.myContainer.getViewHierarchy();
        if (viewHierarchy == null) {
            return;
        }
        boolean hoverIsSelected = this.myHoveredView.tag != null && this.myContainer.isSelected(this.myHoveredView.tag);
        DrawingStyle style = hoverIsSelected ? DrawingStyle.HOVER_SELECTION : DrawingStyle.HOVER;
        Rectangle r = this.myContainer.fromModel(component, this.myHoveredView.getBounds());
        Shape prevClip = gc.getClip();
        Shape clip = this.setScreenClip(this.myContainer, component, gc, deltaX, deltaY);
        DesignerGraphics.drawFilledRect(style, gc, r.x + deltaX, r.y + deltaY, r.width, r.height);
        if (clip != null) {
            gc.setClip(prevClip);
        }
    }
}

