/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.ddms.screenshot.ScreenshotViewer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import icons.AndroidIcons;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nullable;

public class SaveScreenshotAction
extends AnAction {
    private final RenderContext myContext;

    public SaveScreenshotAction(RenderContext context) {
        super("Save Screenshot...", null, AndroidIcons.Ddms.ScreenCapture);
        this.myContext = context;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(this.myContext.getRenderedImage() != null && e.getProject() != null);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = e.getProject();
        try {
            BufferedImage image = this.myContext.getRenderedImage();
            assert (image != null && project != null);
            File backingFile = FileUtil.createTempFile((String)"screenshot", (String)".png", (boolean)true);
            ImageIO.write((RenderedImage)image, "png", backingFile);
            final ScreenshotViewer viewer = new ScreenshotViewer(project, image, backingFile, null, this.getDeviceName());
            viewer.showAndGetOk().doWhenDone((Consumer)new Consumer<Boolean>(){

                public void consume(Boolean ok) {
                    if (ok.booleanValue()) {
                        File screenshot = viewer.getScreenshot();
                        VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(screenshot);
                        if (vf != null) {
                            FileEditorManager.getInstance((Project)project).openFile(vf, true);
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("android.ddms.screenshot.generic.error", e), (String)AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]));
        }
    }

    @Nullable
    private String getDeviceName() {
        Configuration config = this.myContext.getConfiguration();
        if (config == null) {
            return null;
        }
        Device device = config.getDevice();
        if (device == null) {
            return null;
        }
        return device.getDisplayName();
    }
}

