/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.tools.fd.client.InstantRunArtifact;
import com.android.tools.fd.client.InstantRunArtifactType;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.DeployApkTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class SplitApkDeployTask
implements LaunchTask {
    @NotNull
    private final String myPkgName;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final InstantRunBuildInfo myBuildInfo;

    public SplitApkDeployTask(@NotNull String pkgName, @NotNull AndroidFacet facet, @NotNull InstantRunBuildInfo buildInfo) {
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/tasks/SplitApkDeployTask", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/tasks/SplitApkDeployTask", "<init>"));
        }
        if (buildInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildInfo", "com/android/tools/idea/run/tasks/SplitApkDeployTask", "<init>"));
        }
        this.myPkgName = pkgName;
        this.myFacet = facet;
        this.myBuildInfo = buildInfo;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Installing APKs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/SplitApkDeployTask", "getDescription"));
        }
        return "Installing APKs";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/SplitApkDeployTask", "perform"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/SplitApkDeployTask", "perform"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/SplitApkDeployTask", "perform"));
        }
        InstantRunManager.displayVerifierStatus(this.myFacet, this.myBuildInfo);
        List artifacts = this.myBuildInfo.getArtifacts();
        ArrayList installOptions = Lists.newArrayList();
        if (!this.myBuildInfo.hasMainApk()) {
            installOptions.add("-p");
            installOptions.add(this.myPkgName);
        }
        ArrayList apks = Lists.newArrayListWithExpectedSize((int)artifacts.size());
        for (InstantRunArtifact artifact : artifacts) {
            if (artifact.type != InstantRunArtifactType.SPLIT_MAIN && artifact.type != InstantRunArtifactType.SPLIT) continue;
            apks.add(artifact.file);
        }
        String cmd = SplitApkDeployTask.getAdbInstallCommand(apks, installOptions);
        printer.stdout(cmd);
        InstantRunManager.LOG.info(cmd);
        try {
            device.installPackages((List)apks, true, (List)installOptions, 5L, TimeUnit.MINUTES);
            InstantRunManager.transferLocalIdToDeviceId(device, this.myFacet.getModule());
            DeployApkTask.cacheManifestInstallationData(device, this.myFacet, this.myPkgName);
            InstantRunStatsService.get(this.myFacet.getModule().getProject()).notifyDeployType(InstantRunStatsService.DeployType.SPLITAPK);
            return true;
        }
        catch (InstallException e) {
            launchStatus.terminateLaunch("Error installing split apks: " + (Object)((Object)e));
            return false;
        }
    }

    @NotNull
    private static String getAdbInstallCommand(@NotNull List<File> apks, @NotNull List<String> installOptions) {
        if (apks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apks", "com/android/tools/idea/run/tasks/SplitApkDeployTask", "getAdbInstallCommand"));
        }
        if (installOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installOptions", "com/android/tools/idea/run/tasks/SplitApkDeployTask", "getAdbInstallCommand"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("$ adb install-multiple -r ");
        if (!installOptions.isEmpty()) {
            sb.append(Joiner.on((char)' ').join(installOptions));
            sb.append(' ');
        }
        for (File f : apks) {
            sb.append(f.getPath());
            sb.append(' ');
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/SplitApkDeployTask", "getAdbInstallCommand"));
        }
        return string;
    }
}

