/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jdks {
    @NonNls
    public static final String DOWNLOAD_JDK_7_URL = "http://www.oracle.com/technetwork/java/javase/downloads/jdk7-downloads-1880260.html";
    private static final LanguageLevel DEFAULT_LANG_LEVEL = LanguageLevel.JDK_1_6;

    @Nullable
    public static Sdk chooseOrCreateJavaSdk() {
        return Jdks.chooseOrCreateJavaSdk(null);
    }

    @Nullable
    public static Sdk chooseOrCreateJavaSdk(@Nullable LanguageLevel langLevel) {
        if (langLevel == null) {
            langLevel = DEFAULT_LANG_LEVEL;
        }
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!Jdks.isApplicableJdk(sdk, langLevel)) continue;
            return sdk;
        }
        String jdkHomePath = Jdks.getJdkHomePath(langLevel);
        if (jdkHomePath != null) {
            return Jdks.createJdk(jdkHomePath);
        }
        return null;
    }

    public static boolean isApplicableJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/android/tools/idea/sdk/Jdks", "isApplicableJdk"));
        }
        return Jdks.isApplicableJdk(jdk, null);
    }

    public static boolean isApplicableJdk(@NotNull Sdk jdk, @Nullable LanguageLevel langLevel) {
        JavaSdkVersion version;
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/android/tools/idea/sdk/Jdks", "isApplicableJdk"));
        }
        if (!(jdk.getSdkType() instanceof JavaSdk)) {
            return false;
        }
        if (langLevel == null) {
            langLevel = DEFAULT_LANG_LEVEL;
        }
        if ((version = JavaSdk.getInstance().getVersion(jdk)) != null) {
            return Jdks.hasMatchingLangLevel(version, langLevel);
        }
        return false;
    }

    @Nullable
    public static String getJdkHomePath(@NotNull LanguageLevel langLevel) {
        if (langLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "langLevel", "com/android/tools/idea/sdk/Jdks", "getJdkHomePath"));
        }
        ArrayList jdkHomePaths = new ArrayList(JavaSdk.getInstance().suggestHomePaths());
        if (jdkHomePaths.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String javaHome = SystemProperties.getJavaHome();
        if (javaHome != null && !javaHome.isEmpty()) {
            Iterator it = jdkHomePaths.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (path == null || !javaHome.startsWith(path)) continue;
                it.remove();
                list.add(path);
            }
        }
        list.addAll(jdkHomePaths);
        return Jdks.getBestJdkHomePath(list, langLevel);
    }

    @VisibleForTesting
    @Nullable
    static String getBestJdkHomePath(@NotNull Collection<String> jdkHomePaths, @NotNull LanguageLevel langLevel) {
        if (jdkHomePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkHomePaths", "com/android/tools/idea/sdk/Jdks", "getBestJdkHomePath"));
        }
        if (langLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "langLevel", "com/android/tools/idea/sdk/Jdks", "getBestJdkHomePath"));
        }
        ArrayList roots = Lists.newArrayList();
        for (String jdkHomePath : jdkHomePaths) {
            if (!StringUtil.isNotEmpty((String)jdkHomePath)) continue;
            roots.add(jdkHomePath);
            roots.addAll(Jdks.getChildrenPaths(jdkHomePath));
        }
        return Jdks.getBestJdk(roots, langLevel);
    }

    @NotNull
    private static List<String> getChildrenPaths(@NotNull String dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/android/tools/idea/sdk/Jdks", "getChildrenPaths"));
        }
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/Jdks", "getChildrenPaths"));
            }
            return list;
        }
        ArrayList childrenPaths = Lists.newArrayList();
        for (File child : FileUtil.notNullize((File[])dir.listFiles())) {
            boolean directory = child.isDirectory();
            if (!directory) continue;
            childrenPaths.add(child.getAbsolutePath());
        }
        ArrayList arrayList = childrenPaths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/Jdks", "getChildrenPaths"));
        }
        return arrayList;
    }

    @Nullable
    private static String getBestJdk(@NotNull List<String> jdkRoots, @NotNull LanguageLevel langLevel) {
        if (jdkRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkRoots", "com/android/tools/idea/sdk/Jdks", "getBestJdk"));
        }
        if (langLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "langLevel", "com/android/tools/idea/sdk/Jdks", "getBestJdk"));
        }
        String bestJdk = null;
        for (String jdkRoot : jdkRoots) {
            if (!JavaSdk.getInstance().isValidSdkHome(jdkRoot)) continue;
            if (bestJdk == null && Jdks.hasMatchingLangLevel(jdkRoot, langLevel)) {
                bestJdk = jdkRoot;
                continue;
            }
            if (bestJdk == null) continue;
            bestJdk = Jdks.selectJdk(bestJdk, jdkRoot, langLevel);
        }
        return bestJdk;
    }

    @Nullable
    private static String selectJdk(@NotNull String jdk1, @NotNull String jdk2, @NotNull LanguageLevel langLevel) {
        if (jdk1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk1", "com/android/tools/idea/sdk/Jdks", "selectJdk"));
        }
        if (jdk2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk2", "com/android/tools/idea/sdk/Jdks", "selectJdk"));
        }
        if (langLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "langLevel", "com/android/tools/idea/sdk/Jdks", "selectJdk"));
        }
        if (Jdks.hasMatchingLangLevel(jdk1, langLevel)) {
            return jdk1;
        }
        if (Jdks.hasMatchingLangLevel(jdk2, langLevel)) {
            return jdk2;
        }
        return null;
    }

    private static boolean hasMatchingLangLevel(@NotNull String jdkRoot, @NotNull LanguageLevel langLevel) {
        if (jdkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkRoot", "com/android/tools/idea/sdk/Jdks", "hasMatchingLangLevel"));
        }
        if (langLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "langLevel", "com/android/tools/idea/sdk/Jdks", "hasMatchingLangLevel"));
        }
        JavaSdkVersion version = Jdks.getVersion(jdkRoot);
        return Jdks.hasMatchingLangLevel(version, langLevel);
    }

    @VisibleForTesting
    static boolean hasMatchingLangLevel(@NotNull JavaSdkVersion jdkVersion, @NotNull LanguageLevel langLevel) {
        if (jdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkVersion", "com/android/tools/idea/sdk/Jdks", "hasMatchingLangLevel"));
        }
        if (langLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "langLevel", "com/android/tools/idea/sdk/Jdks", "hasMatchingLangLevel"));
        }
        LanguageLevel max = jdkVersion.getMaxLanguageLevel();
        return max.isAtLeast(langLevel);
    }

    @NotNull
    private static JavaSdkVersion getVersion(@NotNull String jdkRoot) {
        if (jdkRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkRoot", "com/android/tools/idea/sdk/Jdks", "getVersion"));
        }
        String version = JavaSdk.getInstance().getVersionString(jdkRoot);
        if (version == null) {
            JavaSdkVersion javaSdkVersion = JavaSdkVersion.JDK_1_0;
            if (javaSdkVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/Jdks", "getVersion"));
            }
            return javaSdkVersion;
        }
        JavaSdkVersion sdkVersion = JavaSdk.getInstance().getVersion(version);
        JavaSdkVersion javaSdkVersion = sdkVersion == null ? JavaSdkVersion.JDK_1_0 : sdkVersion;
        if (javaSdkVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/Jdks", "getVersion"));
        }
        return javaSdkVersion;
    }

    @Nullable
    public static Sdk createJdk(@NotNull String jdkHomePath) {
        if (jdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkHomePath", "com/android/tools/idea/sdk/Jdks", "createJdk"));
        }
        Sdk jdk = SdkConfigurationUtil.createAndAddSDK((String)jdkHomePath, (SdkType)JavaSdk.getInstance());
        if (jdk == null) {
            String msg = String.format("Unable to create JDK from path '%1$s'", jdkHomePath);
            Logger.getInstance(Jdks.class).error(msg);
        }
        return jdk;
    }
}

