/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.repository.Revision;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionHelper;
import com.android.sdklib.LayoutlibVersion;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.sdk.remote.internal.packages.LayoutlibVersionMixin;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteMinToolsPkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePackageParserUtils;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

public class RemotePlatformPkgInfo
extends RemoteMinToolsPkgInfo {
    private final String mVersionName;
    private final LayoutlibVersionMixin mLayoutlibVersion;

    public RemotePlatformPkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        this.mVersionName = RemotePackageParserUtils.getXmlString(packageNode, "version");
        int apiLevel = RemotePackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = RemotePackageParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        AndroidVersion version = new AndroidVersion(apiLevel, codeName);
        this.mLayoutlibVersion = new LayoutlibVersionMixin(packageNode);
        PkgDesc.Builder pkgDescBuilder = PkgDesc.Builder.newPlatform((AndroidVersion)version, (Revision)this.getRevision(), (Revision)this.getMinToolsRevision());
        pkgDescBuilder.setDescriptionShort(RemotePlatformPkgInfo.createShortDescription(this.mListDisplay, this.getRevision(), this.mVersionName, version, this.isObsolete()));
        pkgDescBuilder.setDescriptionUrl(this.getDescUrl());
        pkgDescBuilder.setListDisplay(RemotePlatformPkgInfo.createListDescription(this.mListDisplay, this.mVersionName, version, this.isObsolete()));
        pkgDescBuilder.setIsObsolete(this.isObsolete());
        pkgDescBuilder.setLicense(this.getLicense());
        this.mPkgDesc = pkgDescBuilder.create();
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        AndroidVersionHelper.saveProperties((AndroidVersion)this.getAndroidVersion(), (Properties)props);
        this.mLayoutlibVersion.saveProperties(props);
        if (this.mVersionName != null) {
            props.setProperty("Platform.Version", this.mVersionName);
        }
    }

    public String getVersionName() {
        return this.mVersionName;
    }

    @NotNull
    public AndroidVersion getAndroidVersion() {
        AndroidVersion androidVersion = this.getPkgDesc().getAndroidVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/remote/internal/packages/RemotePlatformPkgInfo", "getAndroidVersion"));
        }
        return androidVersion;
    }

    @Override
    public String installId() {
        return AndroidTargetHash.getPlatformHashString((AndroidVersion)this.getAndroidVersion());
    }

    private static String createListDescription(String listDisplay, String versionName, AndroidVersion version, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s%2$s", listDisplay, obsolete ? " (Obsolete)" : "");
        }
        String s = version.isPreview() ? String.format("SDK Platform Android %1$s Preview%2$s", versionName, obsolete ? " (Obsolete)" : "") : String.format("SDK Platform Android %1$s%2$s", versionName, obsolete ? " (Obsolete)" : "");
        return s;
    }

    private static String createShortDescription(String listDisplay, Revision revision, String versionName, AndroidVersion version, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", listDisplay, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        String s = version.isPreview() ? String.format("SDK Platform Android %1$s Preview, revision %2$s%3$s", versionName, revision.toShortString(), obsolete ? " (Obsolete)" : "") : String.format("SDK Platform Android %1$s, API %2$d, revision %3$s%4$s", versionName, version.getApiLevel(), revision.toShortString(), obsolete ? " (Obsolete)" : "");
        return s;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mLayoutlibVersion == null ? 0 : this.mLayoutlibVersion.hashCode());
        result = 31 * result + (this.getPkgDesc().hasAndroidVersion() ? 0 : this.getPkgDesc().getAndroidVersion().hashCode());
        result = 31 * result + (this.mVersionName == null ? 0 : this.mVersionName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RemotePlatformPkgInfo)) {
            return false;
        }
        RemotePlatformPkgInfo other = (RemotePlatformPkgInfo)obj;
        if (this.mLayoutlibVersion == null ? other.mLayoutlibVersion != null : !this.mLayoutlibVersion.equals(other.mLayoutlibVersion)) {
            return false;
        }
        return !(this.mVersionName == null ? other.mVersionName != null : !this.mVersionName.equals(other.mVersionName));
    }

    @Nullable
    public LayoutlibVersion getLayoutLibVersion() {
        return this.mLayoutlibVersion.getLayoutlibVersion();
    }
}

