/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.repository.Revision;
import com.android.repository.io.FileOp;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionHelper;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.sdk.remote.internal.ITaskMonitor;
import com.android.tools.idea.sdk.remote.internal.archives.Archive;
import com.android.tools.idea.sdk.remote.internal.packages.IMinApiLevelDependency;
import com.android.tools.idea.sdk.remote.internal.packages.RemoteMinToolsPkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePackageParserUtils;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

public class RemoteSamplePkgInfo
extends RemoteMinToolsPkgInfo
implements IMinApiLevelDependency {
    private final int mMinApiLevel;

    public RemoteSamplePkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        int apiLevel = RemotePackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = RemotePackageParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        AndroidVersion version = new AndroidVersion(apiLevel, codeName);
        this.mMinApiLevel = RemotePackageParserUtils.getXmlInt(packageNode, "min-api-level", 0);
        PkgDesc.Builder pkgDescBuilder = PkgDesc.Builder.newSample((AndroidVersion)version, (Revision)this.getRevision(), (Revision)this.getMinToolsRevision());
        pkgDescBuilder.setDescriptionShort(RemoteSamplePkgInfo.createShortDescription(this.mListDisplay, this.getRevision(), version, this.isObsolete()));
        pkgDescBuilder.setDescriptionUrl(this.getDescUrl());
        pkgDescBuilder.setListDisplay(RemoteSamplePkgInfo.createListDescription(this.mListDisplay, version, this.isObsolete()));
        pkgDescBuilder.setIsObsolete(this.isObsolete());
        pkgDescBuilder.setLicense(this.getLicense());
        this.mPkgDesc = pkgDescBuilder.create();
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        AndroidVersionHelper.saveProperties((AndroidVersion)this.getAndroidVersion(), (Properties)props);
        if (this.getMinApiLevel() != 0) {
            props.setProperty("Sample.MinApiLevel", Integer.toString(this.getMinApiLevel()));
        }
    }

    @Override
    public int getMinApiLevel() {
        return this.mMinApiLevel;
    }

    @NotNull
    public AndroidVersion getAndroidVersion() {
        AndroidVersion androidVersion = this.getPkgDesc().getAndroidVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/remote/internal/packages/RemoteSamplePkgInfo", "getAndroidVersion"));
        }
        return androidVersion;
    }

    @Override
    public String installId() {
        return "sample-" + this.getAndroidVersion().getApiString();
    }

    private static String createListDescription(String listDisplay, AndroidVersion version, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s%2$s", listDisplay, obsolete ? " (Obsolete)" : "");
        }
        String s = String.format("Samples for SDK API %1$s%2$s%3$s", version.getApiString(), version.isPreview() ? " Preview" : "", obsolete ? " (Obsolete)" : "");
        return s;
    }

    private static String createShortDescription(String listDisplay, Revision revision, AndroidVersion version, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", listDisplay, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        String s = String.format("Samples for SDK API %1$s%2$s, revision %3$s%4$s", version.getApiString(), version.isPreview() ? " Preview" : "", revision.toShortString(), obsolete ? " (Obsolete)" : "");
        return s;
    }

    @Override
    public void postInstallHook(Archive archive, ITaskMonitor monitor, File installFolder) {
        super.postInstallHook(archive, monitor, installFolder);
        if (installFolder != null) {
            String h = this.computeContentHash(installFolder);
            this.saveContentHash(installFolder, h);
        }
    }

    @Override
    public void postUnzipFileHook(Archive archive, ITaskMonitor monitor, FileOp fileOp, File unzippedFile, ZipArchiveEntry zipEntry) {
        super.postUnzipFileHook(archive, monitor, fileOp, unzippedFile, zipEntry);
        if (fileOp.isFile(unzippedFile) && !"source.properties".equals(unzippedFile.getName())) {
            fileOp.setReadOnly(unzippedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContentHash(File folder) {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            File f = new File(folder, "content_hash.properties");
            if (f.isFile()) {
                fis = new FileInputStream(f);
                props.load(fis);
                String string = props.getProperty("content-hash", null);
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveContentHash(File folder, String hash) {
        Properties props = new Properties();
        props.setProperty("content-hash", hash == null ? "" : hash);
        FileOutputStream fos = null;
        try {
            File f = new File(folder, "content_hash.properties");
            fos = new FileOutputStream(f);
            props.store(fos, "## Android - hash of this archive.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String computeContentHash(File installFolder) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (md != null) {
            this.hashDirectoryContent(installFolder, md);
            return this.getDigestHexString(md);
        }
        return null;
    }

    private void hashDirectoryContent(File folder, MessageDigest md) {
        if (folder == null || md == null || !folder.isDirectory()) {
            return;
        }
        for (File f : folder.listFiles()) {
            if (f.isDirectory()) {
                this.hashDirectoryContent(f, md);
                continue;
            }
            String name = f.getName();
            if (name == null || "content_hash.properties".equals(name)) continue;
            try {
                md.update(name.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                long len = f.length();
                md.update((byte)(len & 0xFFL));
                md.update((byte)(len >> 8 & 0xFFL));
                md.update((byte)(len >> 16 & 0xFFL));
                md.update((byte)(len >> 24 & 0xFFL));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private String getDigestHexString(MessageDigest digester) {
        byte[] digest = digester.digest();
        int n = digest.length;
        String hex = "0123456789abcdef";
        char[] hexDigest = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int b = digest[i] & 0xFF;
            hexDigest[i * 2 + 0] = hex.charAt(b >>> 4);
            hexDigest[i * 2 + 1] = hex.charAt(b & 0xF);
        }
        return new String(hexDigest);
    }
}

