/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.RemotePackage;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HandleSkippedInstallationsModel
extends WizardModel {
    private final Project myProject;
    private List<RemotePackage> mySkippedInstallRequests;
    private File mySdkRoot;
    private BoolProperty myUseStandaloneSdkManager;

    public HandleSkippedInstallationsModel(@Nullable Project project, @NotNull List<RemotePackage> skippedInstallRequests, File sdkRoot) {
        if (skippedInstallRequests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedInstallRequests", "com/android/tools/idea/sdk/wizard/HandleSkippedInstallationsModel", "<init>"));
        }
        this.myUseStandaloneSdkManager = new BoolValueProperty();
        this.myProject = project;
        this.mySkippedInstallRequests = skippedInstallRequests;
        this.mySdkRoot = sdkRoot;
    }

    public BoolProperty useStandaloneSdkManager() {
        return this.myUseStandaloneSdkManager;
    }

    public List<RemotePackage> getSkippedInstallRequests() {
        return this.mySkippedInstallRequests;
    }

    @Override
    protected void handleFinished() {
        if (!((Boolean)this.myUseStandaloneSdkManager.get()).booleanValue()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                SdkQuickfixUtils.startSdkManagerAndExit(HandleSkippedInstallationsModel.this.myProject, HandleSkippedInstallationsModel.this.mySdkRoot);
            }
        });
    }
}

