/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.RepoPackage;
import com.android.tools.idea.sdk.wizard.HandleSkippedInstallationsModel;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.swing.SelectedProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.utils.HtmlBuilder;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class InstallMissingPackagesStep
extends ModelWizardStep<HandleSkippedInstallationsModel> {
    private JPanel myRootPanel;
    private JPanel myOptionsPanel;
    private JBRadioButton myStandaloneSdkManagerButton;
    private JBRadioButton mySkipInstallationButton;
    private JBLabel myErrorMessageLabel;
    private BindingsManager myBindings;

    public InstallMissingPackagesStep(@NotNull HandleSkippedInstallationsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/sdk/wizard/InstallMissingPackagesStep", "<init>"));
        }
        super(model, "Install Missing Packages");
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
    }

    private void createUIComponents() {
        this.myOptionsPanel = new JPanel(new FlowLayout(4));
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/InstallMissingPackagesStep", "getComponent"));
        }
        return jPanel;
    }

    @Override
    protected boolean shouldShow() {
        return !((HandleSkippedInstallationsModel)this.getModel()).getSkippedInstallRequests().isEmpty();
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/sdk/wizard/InstallMissingPackagesStep", "onWizardStarting"));
        }
        ButtonGroup optionsGroup = new ButtonGroup();
        optionsGroup.add((AbstractButton)this.myStandaloneSdkManagerButton);
        optionsGroup.add((AbstractButton)this.mySkipInstallationButton);
        this.myStandaloneSdkManagerButton.setSelected(true);
        this.myBindings.bind(((HandleSkippedInstallationsModel)this.getModel()).useStandaloneSdkManager(), new SelectedProperty((AbstractButton)this.myStandaloneSdkManagerButton));
        this.myErrorMessageLabel.setText(this.generateErrorDisplayMessage());
    }

    private String generateErrorDisplayMessage() {
        HtmlBuilder warningBuilder = new HtmlBuilder();
        warningBuilder.openHtmlBody();
        warningBuilder.add("The following packages were not installed.");
        warningBuilder.newline();
        warningBuilder.newline();
        warningBuilder.beginList();
        for (RepoPackage repoPackage : ((HandleSkippedInstallationsModel)this.getModel()).getSkippedInstallRequests()) {
            warningBuilder.listItem().add(repoPackage.getDisplayName());
        }
        warningBuilder.endList();
        warningBuilder.newline();
        warningBuilder.add("Would you like to exit ").add(ApplicationNamesInfo.getInstance().getFullProductName()).add(" and install the following packages using the standalone SDK manager?");
        warningBuilder.closeHtmlBody();
        return warningBuilder.getHtml();
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = this.myOptionsPanel;
        jPanel2.setLayout(new FlowLayout(1, 5, 5));
        jPanel.add((Component)jPanel2, "South");
        this.myStandaloneSdkManagerButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Exit and Launch SDK Manager");
        Component component = jPanel2.add((Component)jBRadioButton2);
        this.mySkipInstallationButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Skip Installation");
        Component component2 = jPanel2.add((Component)jBRadioButton);
        this.myErrorMessageLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        Font font = jBLabel.getFont();
        if (font != null) {
            jBLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        jPanel.add((Component)jBLabel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

