/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.sdkv2.StudioDownloader;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdkv2.StudioSettingsController;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentInstaller {
    @Nullable
    private final Map<String, RemotePackage> myRemotePackages;
    private final boolean myInstallUpdates;
    private final AndroidSdkHandler mySdkHandler;

    public ComponentInstaller(@Nullable Map<String, RemotePackage> remotePackages, boolean installUpdates, @NotNull AndroidSdkHandler sdkHandler) {
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/welcome/install/ComponentInstaller", "<init>"));
        }
        this.myRemotePackages = remotePackages;
        this.myInstallUpdates = installUpdates;
        this.mySdkHandler = sdkHandler;
    }

    public List<RemotePackage> getPackagesToInstall(@NotNull Iterable<? extends InstallableComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/welcome/install/ComponentInstaller", "getPackagesToInstall"));
        }
        HashSet requests = Sets.newHashSet();
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = this.mySdkHandler.getSdkManager((ProgressIndicator)progress);
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (ProgressIndicator)progress, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        RepositoryPackages allPackages = sdkManager.getPackages();
        for (InstallableComponent installableComponent : components) {
            for (String s : installableComponent.getRequiredSdkPackages(this.myRemotePackages)) {
                UpdatablePackage p = (UpdatablePackage)allPackages.getConsolidatedPkgs().get(s);
                if (p == null || !this.myInstallUpdates && p.hasLocal()) continue;
                requests.add(p);
            }
        }
        ArrayList resolved = Lists.newArrayList();
        ArrayList arrayList = Lists.newArrayList();
        SdkQuickfixUtils.resolve(null, requests, sdkManager, resolved, arrayList);
        ArrayList result = Lists.newArrayList();
        for (UpdatablePackage p : resolved) {
            result.add(p.getRemote());
        }
        return result;
    }

    public void installPackages(@NotNull List<RemotePackage> packages, ProgressIndicator progress) throws WizardException {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/welcome/install/ComponentInstaller", "installPackages"));
        }
        for (RemotePackage request : packages) {
            AndroidSdkHandler.findBestInstaller((RepoPackage)request).install(request, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), progress, this.mySdkHandler.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass())), FileOpUtils.create());
        }
    }
}

