/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.resources.ResourceType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.android.augment.AndroidLightClass;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.annotations.NotNull;

public abstract class ResourceTypeClassBase
extends AndroidLightClass {
    private CachedValue<PsiField[]> myFieldsCache;

    public ResourceTypeClassBase(PsiClass context, String name) {
        super(context, name);
    }

    @NotNull
    static PsiField[] buildResourceFields(@NotNull ResourceManager manager, boolean nonFinal, @NotNull String resClassName, @NotNull PsiClass context) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/augment/ResourceTypeClassBase", "buildResourceFields"));
        }
        if (resClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resClassName", "org/jetbrains/android/augment/ResourceTypeClassBase", "buildResourceFields"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/augment/ResourceTypeClassBase", "buildResourceFields"));
        }
        HashMap fieldNames = new HashMap();
        boolean styleable = ResourceType.STYLEABLE.getName().equals(resClassName);
        PsiPrimitiveType basicType = styleable ? PsiType.INT.createArrayType() : PsiType.INT;
        for (String resName : manager.getResourceNames(resClassName)) {
            fieldNames.put(resName, basicType);
        }
        if (styleable) {
            for (ResourceEntry entry : manager.getValueResourceEntries(ResourceType.ATTR.getName())) {
                String resName = entry.getName();
                String resContext = entry.getContext();
                if (resContext.length() <= 0) continue;
                fieldNames.put(resContext + '_' + resName, PsiType.INT);
            }
        }
        PsiField[] result = new PsiField[fieldNames.size()];
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        int idIterator = ResourceType.getEnum((String)resClassName).ordinal() * 100000;
        int i = 0;
        for (Map.Entry entry : fieldNames.entrySet()) {
            String fieldName = AndroidResourceUtil.getFieldNameByResourceName((String)entry.getKey());
            PsiType type = (PsiType)entry.getValue();
            int id = -idIterator++;
            AndroidLightField field = new AndroidLightField(fieldName, context, type, !nonFinal, nonFinal ? null : Integer.valueOf(id));
            field.setInitializer(factory.createExpressionFromText(Integer.toString(id), (PsiElement)field));
            result[i++] = field;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/ResourceTypeClassBase", "buildResourceFields"));
        }
        return result;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        if (this.myFieldsCache == null) {
            this.myFieldsCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<PsiField[]>(){

                public CachedValueProvider.Result<PsiField[]> compute() {
                    return CachedValueProvider.Result.create((Object)ResourceTypeClassBase.this.doGetFields(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            });
        }
        PsiField[] psiFieldArray = (PsiField[])this.myFieldsCache.getValue();
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/augment/ResourceTypeClassBase", "getFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    protected abstract PsiField[] doGetFields();
}

