/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.inspections.AndroidMissingOnClickHandlerInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OnClickConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    private static final String DEFAULT_MENU_ITEM_CLASS = "android.view.MenuItem";
    private static final String ABS_MENU_ITEM_CLASS = "com.actionbarsherlock.view.MenuItem";
    public static final OnClickConverter CONVERTER_FOR_LAYOUT = new OnClickConverter(){

        @Override
        @NotNull
        public String getDefaultMethodParameterType(@NotNull PsiClass parentClass) {
            if (parentClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "org/jetbrains/android/dom/converters/OnClickConverter$1", "getDefaultMethodParameterType"));
            }
            if ("android.view.View" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$1", "getDefaultMethodParameterType"));
            }
            return "android.view.View";
        }

        @Override
        protected boolean isAllowedMethodParameterType(@NotNull String type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/dom/converters/OnClickConverter$1", "isAllowedMethodParameterType"));
            }
            return "android.view.View".equals(type);
        }

        @Override
        @NotNull
        public String getShortParameterName() {
            if ("View" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$1", "getShortParameterName"));
            }
            return "View";
        }
    };
    public static final OnClickConverter CONVERTER_FOR_MENU = new OnClickConverter(){

        @Override
        @NotNull
        public String getDefaultMethodParameterType(@NotNull PsiClass parentClass) {
            if (parentClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "org/jetbrains/android/dom/converters/OnClickConverter$2", "getDefaultMethodParameterType"));
            }
            Project project = parentClass.getProject();
            PsiClass watsonClass = JavaPsiFacade.getInstance((Project)project).findClass("android.support.v4.app.Watson", GlobalSearchScope.projectScope((Project)project));
            String string = watsonClass != null && parentClass.isInheritor(watsonClass, true) ? OnClickConverter.ABS_MENU_ITEM_CLASS : OnClickConverter.DEFAULT_MENU_ITEM_CLASS;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$2", "getDefaultMethodParameterType"));
            }
            return string;
        }

        @Override
        protected boolean isAllowedMethodParameterType(@NotNull String type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/dom/converters/OnClickConverter$2", "isAllowedMethodParameterType"));
            }
            return OnClickConverter.DEFAULT_MENU_ITEM_CLASS.equals(type) || OnClickConverter.ABS_MENU_ITEM_CLASS.equals(type);
        }

        @Override
        @NotNull
        public String getShortParameterName() {
            if ("MenuItem" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$2", "getShortParameterName"));
            }
            return "MenuItem";
        }
    };

    @NotNull
    public abstract String getDefaultMethodParameterType(@NotNull PsiClass var1);

    protected abstract boolean isAllowedMethodParameterType(@NotNull String var1);

    @NotNull
    public abstract String getShortParameterName();

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        int length = element.getTextLength();
        if (length > 1) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new MyReference((XmlAttributeValue)element, new TextRange(1, length - 1))};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter", "createReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter", "createReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    public boolean checkSignature(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/android/dom/converters/OnClickConverter", "checkSignature"));
        }
        if (!PsiType.VOID.equals((Object)method.getReturnType())) {
            return false;
        }
        if (method.hasModifierProperty("static") || method.hasModifierProperty("abstract") || !method.hasModifierProperty("public")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || aClass.isInterface()) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length != 1) {
            return false;
        }
        PsiType paramType = parameters[0].getType();
        if (!(paramType instanceof PsiClassType)) {
            return false;
        }
        PsiClass paramClass = ((PsiClassType)paramType).resolve();
        if (paramClass == null) {
            return false;
        }
        String paramClassName = paramClass.getQualifiedName();
        return paramClassName != null && this.isAllowedMethodParameterType(paramClassName);
    }

    public boolean findHandlerMethod(@NotNull PsiClass psiClass, @NotNull String methodName) {
        PsiMethod[] methods;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/android/dom/converters/OnClickConverter", "findHandlerMethod"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/android/dom/converters/OnClickConverter", "findHandlerMethod"));
        }
        for (PsiMethod method : methods = psiClass.findMethodsByName(methodName, false)) {
            if (!this.checkSignature(method)) continue;
            return true;
        }
        return false;
    }

    private static LookupElement createLookupElement(PsiMethod method) {
        LookupElementBuilder builder = LookupElementBuilder.create((Object)method, (String)method.getName()).withIcon(method.getIcon(1)).withPresentableText(method.getName());
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null ? builder.withTailText(" (" + containingClass.getQualifiedName() + ')') : builder;
    }

    public static class MyResolveResult
    extends PsiElementResolveResult {
        private final boolean myHasCorrectSignature;

        public MyResolveResult(@NotNull PsiElement element, boolean hasCorrectSignature) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/converters/OnClickConverter$MyResolveResult", "<init>"));
            }
            super(element);
            this.myHasCorrectSignature = hasCorrectSignature;
        }

        public boolean hasCorrectSignature() {
            return this.myHasCorrectSignature;
        }
    }

    public class MyReference
    extends PsiPolyVariantReferenceBase<XmlAttributeValue> {
        private MyReference(XmlAttributeValue value, TextRange range) {
            super((PsiElement)value, range, true);
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)((XmlAttributeValue)this.myElement).getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)new ResolveCache.PolyVariantResolver<MyReference>(){

                @NotNull
                public ResolveResult[] resolve(@NotNull MyReference myReference, boolean incompleteCode) {
                    if (myReference == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myReference", "org/jetbrains/android/dom/converters/OnClickConverter$MyReference$1", "resolve"));
                    }
                    ResolveResult[] resolveResultArray = MyReference.this.resolveInner();
                    if (resolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$MyReference$1", "resolve"));
                    }
                    return resolveResultArray;
                }
            }, false, incompleteCode);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$MyReference", "multiResolve"));
            }
            return resolveResultArray;
        }

        @NotNull
        private ResolveResult[] resolveInner() {
            String methodName = ((XmlAttributeValue)this.myElement).getValue();
            if (methodName == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$MyReference", "resolveInner"));
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            if (module == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$MyReference", "resolveInner"));
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            Project project = ((XmlAttributeValue)this.myElement).getProject();
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
            PsiMethod[] methods = cache.getMethodsByName(methodName, module.getModuleWithDependenciesScope());
            if (methods.length == 0) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$MyReference", "resolveInner"));
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            PsiClass activityBaseClass = JavaPsiFacade.getInstance((Project)project).findClass("android.app.Activity", module.getModuleWithDependenciesAndLibrariesScope(false));
            if (activityBaseClass == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$MyReference", "resolveInner"));
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            ArrayList<MyResolveResult> result = new ArrayList<MyResolveResult>();
            ArrayList<MyResolveResult> resultsWithMistake = new ArrayList<MyResolveResult>();
            for (PsiMethod method : methods) {
                PsiClass parentClass = method.getContainingClass();
                if (parentClass == null || !parentClass.isInheritor(activityBaseClass, true)) continue;
                if (OnClickConverter.this.checkSignature(method)) {
                    result.add(new MyResolveResult((PsiElement)method, true));
                    continue;
                }
                resultsWithMistake.add(new MyResolveResult((PsiElement)method, false));
            }
            ResolveResult[] resolveResultArray = result.size() > 0 ? result.toArray(new ResolveResult[result.size()]) : resultsWithMistake.toArray(new ResolveResult[resultsWithMistake.size()]);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$MyReference", "resolveInner"));
            }
            return resolveResultArray;
        }

        @NotNull
        public Object[] getVariants() {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            if (module == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$MyReference", "getVariants"));
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(module);
            if (activityClass == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$MyReference", "getVariants"));
                }
                return EMPTY_ARRAY;
            }
            ArrayList result = new ArrayList();
            HashSet methodNames = new HashSet();
            ClassInheritorsSearch.search((PsiClass)activityClass, (SearchScope)module.getModuleWithDependenciesScope(), (boolean)true).forEach((Processor)new Processor<PsiClass>((Set)methodNames, result){
                final /* synthetic */ Set val$methodNames;
                final /* synthetic */ List val$result;
                {
                    this.val$methodNames = set;
                    this.val$result = list;
                }

                public boolean process(PsiClass c) {
                    for (PsiMethod method : c.getMethods()) {
                        if (!OnClickConverter.this.checkSignature(method) || !this.val$methodNames.add(method.getName())) continue;
                        this.val$result.add(OnClickConverter.createLookupElement(method));
                    }
                    return true;
                }
            });
            Object[] objectArray = ArrayUtil.toObjectArray(result);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$MyReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public OnClickConverter getConverter() {
            OnClickConverter onClickConverter = OnClickConverter.this;
            if (onClickConverter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/OnClickConverter$MyReference", "getConverter"));
            }
            return onClickConverter;
        }
    }
}

