/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.layout;

import com.android.tools.idea.rendering.PsiDataBindingResourceItem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomExtender;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.layout.Import;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLayoutUtil {
    private AndroidLayoutUtil() {
    }

    @NotNull
    public static List<String> getPossibleRoots(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/layout/AndroidLayoutUtil", "getPossibleRoots"));
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add("view");
        result.add("merge");
        result.add("fragment");
        result.addAll(AndroidDomUtil.removeUnambiguousNames(AndroidDomExtender.getViewClassMap(facet)));
        result.remove("View");
        result.add("layout");
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/layout/AndroidLayoutUtil", "getPossibleRoots"));
        }
        return arrayList;
    }

    @Nullable(value="invalid type")
    public static String getAlias(Import anImport) {
        XmlAttributeValue value;
        GenericAttributeValue<PsiClass> type;
        String aliasValue = null;
        String typeValue = null;
        GenericAttributeValue<String> alias = anImport.getAlias();
        if (alias != null && alias.getXmlAttributeValue() != null) {
            aliasValue = alias.getXmlAttributeValue().getValue();
        }
        if ((type = anImport.getType()) != null && (value = type.getXmlAttributeValue()) != null) {
            typeValue = value.getValue();
        }
        return AndroidLayoutUtil.getAlias(typeValue, aliasValue);
    }

    public static String getAlias(@NotNull PsiDataBindingResourceItem anImport) {
        if (anImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anImport", "org/jetbrains/android/dom/layout/AndroidLayoutUtil", "getAlias"));
        }
        return AndroidLayoutUtil.getAlias(anImport.getTypeDeclaration(), anImport.getExtra("alias"));
    }

    private static String getAlias(@Nullable String type, @Nullable String alias) {
        int d;
        if (alias != null || type == null) {
            return alias;
        }
        int i = type.lastIndexOf(46);
        int n = i = i > (d = type.lastIndexOf(36)) ? i : d;
        if (i < 0) {
            return type;
        }
        return type.length() > i + 1 ? type.substring(i + 1) : null;
    }
}

