/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.android.inspections.lint.IntellijLintIssueRegistry;
import org.jetbrains.android.inspections.lint.IntellijLintRequest;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.refactoring.UnusedResourcesUsageViewDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedResourcesProcessor
extends BaseRefactoringProcessor {
    private final String myFilter;
    private final Module[] myModules;
    private PsiElement[] myElements;
    private boolean myIncludeIds;
    private String myCachedCommandName;

    public UnusedResourcesProcessor(@NotNull Project project, @NotNull Module[] modules, @Nullable String filter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "<init>"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "<init>"));
        }
        super(project, null);
        this.myElements = PsiElement.EMPTY_ARRAY;
        this.myCachedCommandName = null;
        this.myModules = modules;
        this.myFilter = filter;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "createUsageViewDescriptor"));
        }
        UnusedResourcesUsageViewDescriptor unusedResourcesUsageViewDescriptor = new UnusedResourcesUsageViewDescriptor(this.myElements);
        if (unusedResourcesUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "createUsageViewDescriptor"));
        }
        return unusedResourcesUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        Map<Issue, Map<File, List<ProblemData>>> map = this.computeUnusedMap();
        List<PsiElement> elements = this.computeUnusedDeclarationElements(map);
        this.myElements = elements.toArray(new PsiElement[elements.size()]);
        UsageInfo[] result = new UsageInfo[this.myElements.length];
        for (PsiElement element : this.myElements) {
            if (element instanceof PsiBinaryFile) {
                SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
                SmartPsiElementPointer smartPointer = smartPointerManager.createSmartPsiElementPointer(element);
                SmartPsiFileRange smartFileRange = smartPointerManager.createSmartPsiFileRangePointer((PsiFile)((PsiBinaryFile)element), TextRange.EMPTY_RANGE);
                result[i] = new UsageInfo(smartPointer, smartFileRange, false, false){

                    public boolean isValid() {
                        return true;
                    }

                    @Nullable
                    public Segment getSegment() {
                        return null;
                    }
                };
                continue;
            }
            result[i] = new UsageInfo(element);
        }
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])result);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @NotNull
    private List<PsiElement> computeUnusedDeclarationElements(Map<Issue, Map<File, List<ProblemData>>> map) {
        ArrayList elements = Lists.newArrayList();
        for (Issue issue : Lists.newArrayList(map.keySet())) {
            if (issue == UnusedResourceDetector.ISSUE || issue == UnusedResourceDetector.ISSUE_IDS) continue;
            map.remove(issue);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        for (Issue issue : new Issue[]{UnusedResourceDetector.ISSUE, UnusedResourceDetector.ISSUE_IDS}) {
            Map<File, List<ProblemData>> fileListMap = map.get(issue);
            if (fileListMap == null || fileListMap.isEmpty()) continue;
            HashMap files = Maps.newHashMap();
            for (File file : fileListMap.keySet()) {
                PsiFile psiFile;
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                if (virtualFile == null || virtualFile.isDirectory() || (psiFile = manager.findFile(virtualFile)) == null) continue;
                files.put(file, psiFile);
            }
            if (files.isEmpty()) continue;
            for (File file : files.keySet()) {
                PsiFile psiFile = (PsiFile)files.get(file);
                if (psiFile == null || !CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)psiFile)) continue;
                List<ProblemData> problems = fileListMap.get(file);
                if (psiFile.getFileType().isBinary()) {
                    if (!this.matchesFilter(fileListMap, file)) continue;
                    elements.add(psiFile);
                    continue;
                }
                ResourceFolderType folderType = ResourceHelper.getFolderType(psiFile);
                if (folderType != ResourceFolderType.VALUES) {
                    if (issue == UnusedResourceDetector.ISSUE_IDS) {
                        Map<File, List<ProblemData>> m = map.get(UnusedResourceDetector.ISSUE);
                        if (m != null && m.containsKey(file)) continue;
                        this.addElementsInFile(elements, psiFile, problems);
                        continue;
                    }
                    if (!this.matchesFilter(fileListMap, file)) continue;
                    elements.add(psiFile);
                    continue;
                }
                this.addElementsInFile(elements, psiFile, problems);
            }
        }
        ArrayList arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "computeUnusedDeclarationElements"));
        }
        return arrayList;
    }

    private void addElementsInFile(List<PsiElement> elements, PsiFile psiFile, List<ProblemData> problems) {
        if (psiFile instanceof XmlFile) {
            ArrayList starts = Lists.newArrayListWithCapacity((int)problems.size());
            for (ProblemData problem : problems) {
                if (!this.matchesFilter(problem)) continue;
                starts.add(problem.getTextRange().getStartOffset());
            }
            Collections.sort(starts, Collections.reverseOrder());
            for (Integer offset : starts) {
                XmlAttribute attribute;
                if (!psiFile.isValid()) continue;
                XmlAttribute remove = attribute = (XmlAttribute)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, XmlAttribute.class, (boolean)false);
                if (attribute == null) {
                    remove = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, XmlTag.class, (boolean)false);
                } else if (!"id".equals(attribute.getLocalName())) {
                    remove = PsiTreeUtil.getParentOfType((PsiElement)attribute, XmlTag.class);
                }
                if (remove == null) continue;
                elements.add((PsiElement)remove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Issue, Map<File, List<ProblemData>>> computeUnusedMap() {
        HashMap map = Maps.newHashMap();
        ArrayList issues = Lists.newArrayListWithExpectedSize((int)2);
        issues.add(UnusedResourceDetector.ISSUE);
        if (this.myIncludeIds) {
            issues.add(UnusedResourceDetector.ISSUE_IDS);
        }
        AnalysisScope scope = new AnalysisScope(this.myProject);
        boolean unusedWasEnabled = UnusedResourceDetector.ISSUE.isEnabledByDefault();
        boolean unusedIdsWasEnabled = UnusedResourceDetector.ISSUE_IDS.isEnabledByDefault();
        UnusedResourceDetector.ISSUE.setEnabledByDefault(true);
        UnusedResourceDetector.ISSUE_IDS.setEnabledByDefault(this.myIncludeIds);
        try {
            IntellijLintClient client = IntellijLintClient.forBatch(this.myProject, map, scope, issues);
            IntellijLintRequest request = new IntellijLintRequest(client, this.myProject, null, Arrays.asList(this.myModules), false);
            request.setScope(Scope.ALL);
            LintDriver lint = new LintDriver((IssueRegistry)new IntellijLintIssueRegistry(), (LintClient)client);
            lint.analyze((LintRequest)request);
        }
        finally {
            UnusedResourceDetector.ISSUE.setEnabledByDefault(unusedWasEnabled);
            UnusedResourceDetector.ISSUE_IDS.setEnabledByDefault(unusedIdsWasEnabled);
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "computeUnusedMap"));
        }
        return hashMap;
    }

    private boolean matchesFilter(@NotNull Map<File, List<ProblemData>> fileListMap, @NotNull File file) {
        if (fileListMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileListMap", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "matchesFilter"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "matchesFilter"));
        }
        if (this.myFilter != null) {
            List<ProblemData> problems = fileListMap.get(file);
            for (ProblemData problem : problems) {
                if (!this.myFilter.equals(UnusedResourceDetector.getUnusedResource((String)problem.getMessage(), (TextFormat)TextFormat.RAW))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean matchesFilter(@NotNull ProblemData problem) {
        if (problem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problem", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "matchesFilter"));
        }
        return this.myFilter == null || this.myFilter.equals(UnusedResourceDetector.getUnusedResource((String)problem.getMessage(), (TextFormat)TextFormat.RAW));
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "preprocessUsages"));
        }
        return true;
    }

    public PsiElement[] getElements() {
        return this.myElements;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "refreshElements"));
        }
        System.arraycopy(elements, 0, this.myElements, 0, elements.length);
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData beforeData = new RefactoringEventData();
        beforeData.addElements(this.myElements);
        return beforeData;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.unused.resources";
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "org/jetbrains/android/refactoring/UnusedResourcesProcessor", "performRefactoring"));
        }
        try {
            for (PsiElement element : this.myElements) {
                if (element == null || !element.isValid()) continue;
                element.delete();
            }
        }
        catch (IncorrectOperationException e) {
            RefactoringUIUtil.processIncorrectOperation((Project)this.myProject, (IncorrectOperationException)e);
        }
    }

    private String calcCommandName() {
        return "Deleting " + RefactoringUIUtil.calculatePsiElementDescriptionList((PsiElement[])this.myElements);
    }

    protected String getCommandName() {
        if (this.myCachedCommandName == null) {
            this.myCachedCommandName = this.calcCommandName();
        }
        return this.myCachedCommandName;
    }

    protected boolean skipNonCodeUsages() {
        return true;
    }

    public void setIncludeIds(boolean includeIds) {
        this.myIncludeIds = includeIds;
    }
}

